/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.StorageType;
import org.jclouds.javax.annotation.Nullable;

public class ServiceOffering
implements Comparable<ServiceOffering> {
    private final String id;
    private final String name;
    private final String displayText;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final int cpuNumber;
    private final int cpuSpeed;
    private final int memory;
    private final boolean haSupport;
    private final StorageType storageType;
    private final Set<String> tags;
    private final boolean defaultUse;
    private final boolean systemOffering;
    private final boolean cpuUseLimited;
    private final long networkRate;
    private final boolean systemVmType;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServiceOffering(this);
    }

    @ConstructorProperties(value={"id", "name", "displaytext", "created", "domain", "domainid", "cpunumber", "cpuspeed", "memory", "offerha", "storagetype", "tags", "defaultuse", "issystem", "limitcpuuse", "networkrate", "systemvmtype"})
    protected ServiceOffering(String id, @Nullable String name, @Nullable String displayText, @Nullable Date created, @Nullable String domain, @Nullable String domainId, int cpuNumber, int cpuSpeed, int memory, boolean haSupport, @Nullable StorageType storageType, @Nullable Iterable<String> tags, boolean defaultUse, boolean systemOffering, boolean cpuUseLimited, long networkRate, boolean systemVmType) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.cpuNumber = cpuNumber;
        this.cpuSpeed = cpuSpeed;
        this.memory = memory;
        this.haSupport = haSupport;
        this.storageType = storageType;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
        this.defaultUse = defaultUse;
        this.systemOffering = systemOffering;
        this.cpuUseLimited = cpuUseLimited;
        this.networkRate = networkRate;
        this.systemVmType = systemVmType;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public int getCpuSpeed() {
        return this.cpuSpeed;
    }

    public int getMemory() {
        return this.memory;
    }

    public boolean supportsHA() {
        return this.haSupport;
    }

    @Nullable
    public StorageType getStorageType() {
        return this.storageType;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean isDefaultUse() {
        return this.defaultUse;
    }

    public boolean isSystemOffering() {
        return this.systemOffering;
    }

    public boolean isCpuUseLimited() {
        return this.cpuUseLimited;
    }

    public long getNetworkRate() {
        return this.networkRate;
    }

    public boolean isSystemVmType() {
        return this.systemVmType;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.cpuNumber, this.cpuSpeed, this.memory, this.haSupport, this.storageType, this.tags, this.defaultUse, this.systemOffering, this.cpuUseLimited, this.networkRate, this.systemVmType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceOffering that = (ServiceOffering)ServiceOffering.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.displayText, that.displayText) && Objects.equal(this.created, that.created) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.cpuNumber, that.cpuNumber) && Objects.equal(this.cpuSpeed, that.cpuSpeed) && Objects.equal(this.memory, that.memory) && Objects.equal(this.haSupport, that.haSupport) && Objects.equal((Object)this.storageType, (Object)that.storageType) && Objects.equal(this.getTags(), that.getTags()) && Objects.equal(this.defaultUse, that.defaultUse) && Objects.equal(this.systemOffering, that.systemOffering) && Objects.equal(this.cpuUseLimited, that.cpuUseLimited) && Objects.equal(this.networkRate, that.networkRate) && Objects.equal(this.systemVmType, that.systemVmType);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("displayText", this.displayText).add("created", this.created).add("domain", this.domain).add("domainId", this.domainId).add("cpuNumber", this.cpuNumber).add("cpuSpeed", this.cpuSpeed).add("memory", this.memory).add("haSupport", this.haSupport).add("storageType", (Object)this.storageType).add("tags", this.getTags()).add("defaultUse", this.defaultUse).add("systemOffering", this.systemOffering).add("cpuUseLimited", this.cpuUseLimited).add("networkRate", this.networkRate).add("systemVmType", this.systemVmType);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(ServiceOffering o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String displayText;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected int cpuNumber;
        protected int cpuSpeed;
        protected int memory;
        protected boolean haSupport;
        protected StorageType storageType;
        protected boolean defaultUse;
        protected boolean systemOffering;
        protected boolean cpuUseLimited;
        protected long networkRate;
        protected boolean systemVmType;
        protected ImmutableSet.Builder<String> tags = ImmutableSet.builder();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T cpuNumber(int cpuNumber) {
            this.cpuNumber = cpuNumber;
            return this.self();
        }

        public T cpuSpeed(int cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this.self();
        }

        public T memory(int memory) {
            this.memory = memory;
            return this.self();
        }

        public T supportsHA(boolean haSupport) {
            this.haSupport = haSupport;
            return this.self();
        }

        public T storageType(StorageType storageType) {
            this.storageType = storageType;
            return this.self();
        }

        public T tags(Iterable<String> tags) {
            this.tags = ImmutableSet.builder().addAll(tags);
            return this.self();
        }

        public T tag(String tag) {
            this.tags.add((Object)tag);
            return this.self();
        }

        public T defaultUse(boolean defaultUse) {
            this.defaultUse = defaultUse;
            return this.self();
        }

        public T systemOffering(boolean systemOffering) {
            this.systemOffering = systemOffering;
            return this.self();
        }

        public T cpuUseLimited(boolean cpuUseLimited) {
            this.cpuUseLimited = cpuUseLimited;
            return this.self();
        }

        public T networkRate(long networkRate) {
            this.networkRate = networkRate;
            return this.self();
        }

        public T systemVmType(boolean systemVmType) {
            this.systemVmType = systemVmType;
            return this.self();
        }

        public ServiceOffering build() {
            return new ServiceOffering(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.cpuNumber, this.cpuSpeed, this.memory, this.haSupport, this.storageType, this.tags.build(), this.defaultUse, this.systemOffering, this.cpuUseLimited, this.networkRate, this.systemVmType);
        }

        public T fromServiceOffering(ServiceOffering in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).displayText(in.getDisplayText())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).cpuNumber(in.getCpuNumber())).cpuSpeed(in.getCpuSpeed())).memory(in.getMemory())).supportsHA(in.supportsHA())).storageType(in.getStorageType())).tags(in.getTags())).defaultUse(in.isDefaultUse())).systemOffering(in.isSystemOffering())).cpuUseLimited(in.isCpuUseLimited())).networkRate(in.getNetworkRate())).systemVmType(in.isSystemVmType());
        }
    }
}

