/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.functions;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.domain.Credentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementVisitor;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

public enum CredentialsFromAdminAccess implements Function<Statement, Credentials>
{
    INSTANCE;


    @Override
    public Credentials apply(@Nullable Statement input) {
        if (input == null) {
            return null;
        }
        if (input instanceof AcceptsStatementVisitor) {
            final AtomicReference credsHolder = Atomics.newReference();
            ((AcceptsStatementVisitor)AcceptsStatementVisitor.class.cast(input)).accept(new StatementVisitor(){

                @Override
                public void visit(Statement in) {
                    Credentials creds;
                    if (credsHolder.get() == null && (creds = CredentialsFromAdminAccess.this.apply(in)) != null) {
                        credsHolder.set(creds);
                    }
                }
            });
            return (Credentials)credsHolder.get();
        }
        if (input instanceof AdminAccess) {
            return ((AdminAccess)AdminAccess.class.cast(input)).getAdminCredentials();
        }
        return null;
    }
}

