/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Tag {
    private final int accountId;
    private final int id;
    private final int internal;
    private final String name;

    @ConstructorProperties(value={"accountId", "id", "internal", "name"})
    public Tag(int accountId, int id, int internal, String name) {
        this.accountId = accountId;
        this.id = id;
        this.internal = internal;
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public int getAccountId() {
        return this.accountId;
    }

    public int getId() {
        return this.id;
    }

    public int getInternal() {
        return this.internal;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag that = (Tag)o;
        return Objects.equal(this.accountId, that.accountId) && Objects.equal(this.id, that.id) && Objects.equal(this.internal, that.internal) && Objects.equal(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.accountId, this.id, this.internal, this.name);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("accountId", this.accountId).add("id", this.id).add("internal", this.internal).add("name", this.name).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Tag.builder().fromTag(this);
    }

    public static class Builder {
        private int accountId;
        private int id;
        private int internal;
        private String name;

        public Builder accountId(int accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder internal(int internal) {
            this.internal = internal;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Tag build() {
            return new Tag(this.accountId, this.id, this.internal, this.name);
        }

        public Builder fromTag(Tag in) {
            return this.accountId(in.getAccountId()).id(in.getId()).internal(in.getInternal()).name(in.getName());
        }
    }
}

