/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Image;
import org.jclouds.azurecompute.arm.domain.ImageProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Image {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    public abstract String location();

    public abstract ImageProperties properties();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"id", "name", "location", "properties", "tags"})
    public static Image create(String id, String name, String location, ImageProperties properties, Map<String, String> tags) {
        return Image.builder().id(id).name(name).location(location).properties(properties).tags(tags).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Image.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder location(String var1);

        public abstract Builder properties(ImageProperties var1);

        public abstract Builder tags(Map<String, String> var1);

        abstract Map<String, String> tags();

        abstract Image autoBuild();

        public Image build() {
            this.tags(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null);
            return this.autoBuild();
        }
    }
}

