/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class AsyncJobError {
    private final ErrorCode errorCode;
    private final String errorText;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAsyncJobError(this);
    }

    @ConstructorProperties(value={"errorcode", "errortext"})
    protected AsyncJobError(@Nullable ErrorCode errorCode, @Nullable String errorText) {
        this.errorCode = errorCode;
        this.errorText = errorText;
    }

    @Nullable
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public String getErrorText() {
        return this.errorText;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.errorCode, this.errorText});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncJobError that = (AsyncJobError)AsyncJobError.class.cast(obj);
        return Objects.equal((Object)this.errorCode, (Object)that.errorCode) && Objects.equal(this.errorText, that.errorText);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("errorCode", (Object)this.errorCode).add("errorText", this.errorText);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected ErrorCode errorCode;
        protected String errorText;

        protected abstract T self();

        public T errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this.self();
        }

        public T errorText(String errorText) {
            this.errorText = errorText;
            return this.self();
        }

        public AsyncJobError build() {
            return new AsyncJobError(this.errorCode, this.errorText);
        }

        public T fromAsyncJobError(AsyncJobError in) {
            return ((Builder)this.errorCode(in.getErrorCode())).errorText(in.getErrorText());
        }
    }

    public static enum ErrorCode {
        INTERNAL_ERROR(530),
        ACCOUNT_ERROR(531),
        ACCOUNT_RESOURCE_LIMIT_ERROR(532),
        INSUFFICIENT_CAPACITY_ERROR(533),
        RESOURCE_UNAVAILABLE_ERROR(534),
        RESOURCE_ALLOCATION_ERROR(535),
        RESOURCE_IN_USE_ERROR(536),
        NETWORK_RULE_CONFLICT_ERROR(537),
        UNKNOWN(-1);

        private final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static ErrorCode fromValue(String value) {
            try {
                int errorCode = Integer.parseInt(value);
                for (ErrorCode candidate : ErrorCode.values()) {
                    if (candidate.code() != errorCode) continue;
                    return candidate;
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }
}

