/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public final class EncryptedPasswordAndPrivateKey {
    private final String encryptedPassword;
    private final String privateKey;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return EncryptedPasswordAndPrivateKey.builder().fromEncryptedPasswordAndPrivateKey(this);
    }

    @ConstructorProperties(value={"encryptedPassword", "privateKey"})
    public EncryptedPasswordAndPrivateKey(@Nullable String encryptedPassword, @Nullable String privateKey) {
        this.encryptedPassword = encryptedPassword;
        this.privateKey = privateKey;
    }

    @Nullable
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    @Nullable
    public String getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.encryptedPassword, this.privateKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedPasswordAndPrivateKey that = (EncryptedPasswordAndPrivateKey)EncryptedPasswordAndPrivateKey.class.cast(obj);
        return Objects.equal(this.encryptedPassword, that.encryptedPassword) && Objects.equal(this.privateKey, that.privateKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("encryptedPassword", this.encryptedPassword).add("privateKey", this.privateKey).toString();
    }

    public static final class Builder {
        protected String encryptedPassword;
        protected String privateKey;

        public Builder encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public EncryptedPasswordAndPrivateKey build() {
            return new EncryptedPasswordAndPrivateKey(this.encryptedPassword, this.privateKey);
        }

        public Builder fromEncryptedPasswordAndPrivateKey(EncryptedPasswordAndPrivateKey in) {
            return this.encryptedPassword(in.getEncryptedPassword()).privateKey(in.getPrivateKey());
        }
    }
}

