/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.functions.LinkToListOptions;
import org.jclouds.http.utils.Queries;

public class LinkToImageListOptions
implements Function<URI, ImageListOptions> {
    @Override
    public ImageListOptions apply(URI input) {
        Preconditions.checkNotNull(input, "input cannot be null");
        Multimap<String, String> queryParams = Queries.queryParser().apply(input.getQuery());
        String nextPage = LinkToListOptions.getFirstOrNull("page", queryParams);
        String nextPerPage = LinkToListOptions.getFirstOrNull("per_page", queryParams);
        String nextType = LinkToListOptions.getFirstOrNull("type", queryParams);
        String nextPrivate = LinkToListOptions.getFirstOrNull("private", queryParams);
        ImageListOptions options = new ImageListOptions();
        if (nextPage != null) {
            options.page(Integer.parseInt(nextPage));
        }
        if (nextPerPage != null) {
            options.perPage(Integer.parseInt(nextPerPage));
        }
        if (nextType != null) {
            options.type(nextType);
        }
        if (nextPrivate != null) {
            options.privateImages(Boolean.parseBoolean(nextPrivate));
        }
        return options;
    }
}

