/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.javax.annotation.Nullable;

public class RunningInstance
implements Comparable<RunningInstance> {
    protected final String region;
    protected final Set<String> groupNames;
    protected final String amiLaunchIndex;
    @Nullable
    protected final String dnsName;
    protected final String imageId;
    protected final String instanceId;
    protected final InstanceState instanceState;
    protected final String rawState;
    protected final String instanceType;
    @Nullable
    protected final String ipAddress;
    @Nullable
    protected final String kernelId;
    @Nullable
    protected final String keyName;
    protected final Date launchTime;
    protected final String availabilityZone;
    protected final String virtualizationType;
    @Nullable
    protected final String platform;
    @Nullable
    protected final String privateDnsName;
    @Nullable
    protected final String privateIpAddress;
    @Nullable
    protected final String ramdiskId;
    @Nullable
    protected final String reason;
    protected final RootDeviceType rootDeviceType;
    @Nullable
    protected final String rootDeviceName;
    protected final Map<String, BlockDevice> ebsBlockDevices;
    protected final Map<String, String> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromRunningInstance(this);
    }

    protected RunningInstance(String region, Iterable<String> groupNames, @Nullable String amiLaunchIndex, @Nullable String dnsName, String imageId, String instanceId, InstanceState instanceState, String rawState, String instanceType, @Nullable String ipAddress, @Nullable String kernelId, @Nullable String keyName, Date launchTime, String availabilityZone, String virtualizationType, @Nullable String platform, @Nullable String privateDnsName, @Nullable String privateIpAddress, @Nullable String ramdiskId, @Nullable String reason, RootDeviceType rootDeviceType, @Nullable String rootDeviceName, Map<String, BlockDevice> ebsBlockDevices, Map<String, String> tags) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.amiLaunchIndex = amiLaunchIndex;
        this.dnsName = dnsName;
        this.imageId = imageId;
        this.instanceId = Preconditions.checkNotNull(instanceId, "instanceId");
        this.instanceState = Preconditions.checkNotNull(instanceState, "instanceState for %s/%s", (Object)region, (Object)instanceId);
        this.rawState = Preconditions.checkNotNull(rawState, "rawState for %s/%s", (Object)region, (Object)instanceId);
        this.instanceType = Preconditions.checkNotNull(instanceType, "instanceType for %s/%s", (Object)region, (Object)instanceId);
        this.ipAddress = ipAddress;
        this.kernelId = kernelId;
        this.keyName = keyName;
        this.launchTime = launchTime;
        this.availabilityZone = availabilityZone;
        this.virtualizationType = virtualizationType;
        this.platform = platform;
        this.privateDnsName = privateDnsName;
        this.privateIpAddress = privateIpAddress;
        this.ramdiskId = ramdiskId;
        this.reason = reason;
        this.rootDeviceType = Preconditions.checkNotNull(rootDeviceType, "rootDeviceType for %s/%s", (Object)region, (Object)instanceId);
        this.rootDeviceName = rootDeviceName;
        this.ebsBlockDevices = ImmutableMap.copyOf(Preconditions.checkNotNull(ebsBlockDevices, "ebsBlockDevices for %s/%s", (Object)region, (Object)instanceId));
        this.groupNames = ImmutableSet.copyOf(Preconditions.checkNotNull(groupNames, "groupNames for %s/%s", (Object)region, (Object)instanceId));
        this.tags = ImmutableMap.copyOf(Preconditions.checkNotNull(tags, "tags"));
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public String getAmiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getId() {
        return this.instanceId;
    }

    public InstanceState getInstanceState() {
        return this.instanceState;
    }

    public String getRawState() {
        return this.rawState;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public String getReason() {
        return this.reason;
    }

    public RootDeviceType getRootDeviceType() {
        return this.rootDeviceType;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public Map<String, BlockDevice> getEbsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public Set<String> getGroupNames() {
        return this.groupNames;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public int compareTo(RunningInstance other) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.region), (Comparable<?>)((Object)other.region)).compare(this.instanceId, other.instanceId, Ordering.natural().nullsLast()).result();
    }

    public int hashCode() {
        return Objects.hashCode(this.region, this.instanceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RunningInstance that = (RunningInstance)RunningInstance.class.cast(obj);
        return Objects.equal(this.region, that.region) && Objects.equal(this.instanceId, that.instanceId);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("region", this.region).add("availabilityZone", this.availabilityZone).add("id", this.instanceId).add("state", this.rawState).add("type", this.instanceType).add("virtualizationType", this.virtualizationType).add("imageId", this.imageId).add("ipAddress", this.ipAddress).add("dnsName", this.dnsName).add("privateIpAddress", this.privateIpAddress).add("privateDnsName", this.privateDnsName).add("keyName", this.keyName).add("groupNames", this.groupNames).add("platform", this.platform).add("launchTime", this.launchTime).add("rootDeviceName", this.rootDeviceName).add("rootDeviceType", (Object)this.rootDeviceType).add("ebsBlockDevices", this.ebsBlockDevices).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }

        @Override
        public RunningInstance build() {
            return new RunningInstance(this.region, this.groupNames, this.amiLaunchIndex, this.dnsName, this.imageId, this.instanceId, this.instanceState, this.rawState, this.instanceType, this.ipAddress, this.kernelId, this.keyName, this.launchTime, this.availabilityZone, this.virtualizationType, this.platform, this.privateDnsName, this.privateIpAddress, this.ramdiskId, this.reason, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices, this.tags);
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String region;
        protected Set<String> groupNames = Sets.newLinkedHashSet();
        protected String amiLaunchIndex;
        protected String dnsName;
        protected String imageId;
        protected String instanceId;
        protected InstanceState instanceState;
        protected String rawState;
        protected String instanceType;
        protected String ipAddress;
        protected String kernelId;
        protected String keyName;
        protected Date launchTime;
        protected String availabilityZone;
        protected String virtualizationType = "paravirtual";
        protected String platform;
        protected String privateDnsName;
        protected String privateIpAddress;
        protected String ramdiskId;
        protected String reason;
        protected RootDeviceType rootDeviceType = RootDeviceType.INSTANCE_STORE;
        protected String rootDeviceName;
        protected Map<String, BlockDevice> ebsBlockDevices = Maps.newLinkedHashMap();
        protected Map<String, String> tags = Maps.newLinkedHashMap();

        protected abstract T self();

        public T tags(Map<String, String> tags) {
            this.tags = ImmutableMap.copyOf(Preconditions.checkNotNull(tags, "tags"));
            return this.self();
        }

        public T tag(String key, String value) {
            if (key != null) {
                this.tags.put(key, Strings.nullToEmpty(value));
            }
            return this.self();
        }

        public T region(String region) {
            this.region = region;
            return this.self();
        }

        public T groupNames(Iterable<String> groupNames) {
            this.groupNames = ImmutableSet.copyOf(Preconditions.checkNotNull(groupNames, "groupNames"));
            return this.self();
        }

        public T groupName(String groupName) {
            if (groupName != null) {
                this.groupNames.add(groupName);
            }
            return this.self();
        }

        public T amiLaunchIndex(String amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this.self();
        }

        public T dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this.self();
        }

        public T imageId(String imageId) {
            this.imageId = imageId;
            return this.self();
        }

        public T instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this.self();
        }

        public T instanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
            return this.self();
        }

        public T rawState(String rawState) {
            this.rawState = rawState;
            return this.self();
        }

        public T instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this.self();
        }

        public T ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this.self();
        }

        public T kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this.self();
        }

        public T keyName(String keyName) {
            this.keyName = keyName;
            return this.self();
        }

        public T launchTime(Date launchTime) {
            this.launchTime = launchTime;
            return this.self();
        }

        public T availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this.self();
        }

        public T virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this.self();
        }

        public T platform(String platform) {
            this.platform = platform;
            return this.self();
        }

        public T privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this.self();
        }

        public T privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this.self();
        }

        public T ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this.self();
        }

        public T reason(String reason) {
            this.reason = reason;
            return this.self();
        }

        public T rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this.self();
        }

        public T rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this.self();
        }

        public T devices(Map<String, BlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = ImmutableMap.copyOf(Preconditions.checkNotNull(ebsBlockDevices, "ebsBlockDevices"));
            return this.self();
        }

        public T device(String key, BlockDevice value) {
            if (key != null && value != null) {
                this.ebsBlockDevices.put(key, value);
            }
            return this.self();
        }

        public T fromRunningInstance(RunningInstance in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.region(in.region)).groupNames(in.groupNames)).amiLaunchIndex(in.amiLaunchIndex)).dnsName(in.dnsName)).imageId(in.imageId)).instanceId(in.instanceId)).instanceState(in.instanceState)).rawState(in.rawState)).instanceType(in.instanceType)).ipAddress(in.ipAddress)).kernelId(in.kernelId)).keyName(in.keyName)).launchTime(in.launchTime)).availabilityZone(in.availabilityZone)).virtualizationType(in.virtualizationType)).platform(in.platform)).privateDnsName(in.privateDnsName)).privateIpAddress(in.privateIpAddress)).ramdiskId(in.ramdiskId)).reason(in.reason)).rootDeviceType(in.rootDeviceType)).rootDeviceName(in.rootDeviceName)).devices(in.ebsBlockDevices)).tags(in.tags);
        }

        public abstract RunningInstance build();
    }
}

