/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.javax.annotation.Nullable;

public class Server
implements Comparable<Server> {
    private final long id;
    private final boolean isSandbox;
    private final String name;
    private final String description;
    private final ServerState state;
    private final Option datacenter;
    private final Option type;
    private final Option ram;
    private final Option os;
    private final Ip ip;
    private final ServerImage image;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServer(this);
    }

    @ConstructorProperties(value={"id", "isSandbox", "name", "description", "state", "datacenter", "type", "ram", "os", "ip", "image"})
    protected Server(long id, boolean isSandbox, String name, @Nullable String description, ServerState state, @Nullable Option datacenter, Option type, Option ram, Option os, Ip ip, ServerImage image) {
        this.id = id;
        this.isSandbox = isSandbox;
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = description;
        this.state = Preconditions.checkNotNull(state, "state");
        this.datacenter = datacenter;
        this.type = Preconditions.checkNotNull(type, "type");
        this.ram = Preconditions.checkNotNull(ram, "ram");
        this.os = Preconditions.checkNotNull(os, "os");
        this.ip = Preconditions.checkNotNull(ip, "ip");
        this.image = Preconditions.checkNotNull(image, "image");
    }

    public long getId() {
        return this.id;
    }

    public boolean isSandbox() {
        return this.isSandbox;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ServerState getState() {
        return this.state;
    }

    @Nullable
    public Option getDatacenter() {
        return this.datacenter;
    }

    public Option getType() {
        return this.type;
    }

    public Option getRam() {
        return this.ram;
    }

    public Option getOs() {
        return this.os;
    }

    public Ip getIp() {
        return this.ip;
    }

    public ServerImage getImage() {
        return this.image;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.isSandbox, this.name, this.description, this.state, this.datacenter, this.type, this.ram, this.os, this.ip, this.image});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Server that = (Server)Server.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.isSandbox, that.isSandbox) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.datacenter, that.datacenter) && Objects.equal(this.type, that.type) && Objects.equal(this.ram, that.ram) && Objects.equal(this.os, that.os) && Objects.equal(this.ip, that.ip) && Objects.equal(this.image, that.image);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("isSandbox", this.isSandbox).add("name", this.name).add("description", this.description).add("state", (Object)this.state).add("datacenter", this.datacenter).add("type", this.type).add("ram", this.ram).add("os", this.os).add("ip", this.ip).add("image", this.image);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Server that) {
        return Longs.compare(this.id, that.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected boolean isSandbox;
        protected String name;
        protected String description;
        protected ServerState state;
        protected Option datacenter;
        protected Option type;
        protected Option ram;
        protected Option os;
        protected Ip ip;
        protected ServerImage image;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T isSandbox(boolean isSandbox) {
            this.isSandbox = isSandbox;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T state(ServerState state) {
            this.state = state;
            return this.self();
        }

        public T datacenter(Option datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public T type(Option type) {
            this.type = type;
            return this.self();
        }

        public T ram(Option ram) {
            this.ram = ram;
            return this.self();
        }

        public T os(Option os) {
            this.os = os;
            return this.self();
        }

        public T ip(Ip ip) {
            this.ip = ip;
            return this.self();
        }

        public T image(ServerImage image) {
            this.image = image;
            return this.self();
        }

        public Server build() {
            return new Server(this.id, this.isSandbox, this.name, this.description, this.state, this.datacenter, this.type, this.ram, this.os, this.ip, this.image);
        }

        public T fromServer(Server in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).isSandbox(in.isSandbox())).name(in.getName())).description(in.getDescription())).state(in.getState())).datacenter(in.getDatacenter())).type(in.getType())).ram(in.getRam())).os(in.getOs())).ip(in.getIp())).image(in.getImage());
        }
    }
}

