/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog.functions;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.catalog.functions.ServiceEndpointResolutionStrategy;

public abstract class BaseEndpointResolutionStrategy
implements ServiceEndpointResolutionStrategy {
    protected abstract Predicate<ServiceEndpoint> filter();

    @Override
    @Nullable
    public Supplier<URI> apply(Collection<ServiceEndpoint> input) {
        Predicate<ServiceEndpoint> filter = this.filter();
        Optional<ServiceEndpoint> serviceEndpoint = Iterables.tryFind(input, filter);
        return Suppliers.ofInstance(serviceEndpoint.isPresent() ? serviceEndpoint.get().url() : null);
    }

    protected static Predicate<ServiceEndpoint> withIface(final ServiceEndpoint.Interface iface) {
        return new Predicate<ServiceEndpoint>(){

            @Override
            public boolean apply(ServiceEndpoint input) {
                return input.iface().equals((Object)iface);
            }

            public String toString() {
                return "interface(" + iface.name().toLowerCase() + ")";
            }
        };
    }
}

