/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.aws.ec2.domain.AutoValue_InternetGateway;
import org.jclouds.aws.ec2.domain.InternetGatewayAttachment;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class InternetGateway {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract List<InternetGatewayAttachment> attachmentSet();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"internetGatewayId", "attachmentSet", "tagSet"})
    public static InternetGateway create(String id, List<InternetGatewayAttachment> attachmentSet, Map<String, String> tags) {
        return InternetGateway.builder().id(id).attachmentSet(attachmentSet).tags(tags).build();
    }

    InternetGateway() {
    }

    public static Builder builder() {
        return new AutoValue_InternetGateway.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder attachmentSet(List<InternetGatewayAttachment> var1);

        public abstract Builder tags(Map<String, String> var1);

        @Nullable
        abstract List<InternetGatewayAttachment> attachmentSet();

        @Nullable
        abstract Map<String, String> tags();

        abstract InternetGateway autoBuild();

        public InternetGateway build() {
            this.tags(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : ImmutableMap.of());
            this.attachmentSet(this.attachmentSet() != null ? ImmutableList.copyOf(this.attachmentSet()) : ImmutableList.of());
            return this.autoBuild();
        }
    }
}

