/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;
import org.jclouds.azurecompute.arm.compute.functions.NetworkSecurityRuleToIpPermission;
import org.jclouds.azurecompute.arm.compute.functions.VirtualMachineToNodeMetadata;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;

@Singleton
public class NetworkSecurityGroupToSecurityGroup
implements Function<NetworkSecurityGroup, SecurityGroup> {
    private final Function<NetworkSecurityRule, IpPermission> ruleToPermission;
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    NetworkSecurityGroupToSecurityGroup(Function<NetworkSecurityRule, IpPermission> ruleToPermission, @Memoized Supplier<Set<? extends Location>> locations) {
        this.ruleToPermission = ruleToPermission;
        this.locations = locations;
    }

    @Override
    public SecurityGroup apply(NetworkSecurityGroup input) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        builder.id(ResourceGroupAndName.fromResourceGroupAndName(IdReference.extractResourceGroup(input.id()), input.name()).slashEncode());
        builder.providerId(input.id());
        builder.name(input.name());
        builder.location(VirtualMachineToNodeMetadata.getLocation(this.locations, input.location()));
        if (input.properties().securityRules() != null) {
            builder.ipPermissions(Iterables.transform(Iterables.filter(input.properties().securityRules(), NetworkSecurityRuleToIpPermission.InboundRule), this.ruleToPermission));
        }
        return builder.build();
    }
}

