/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.Map;
import org.jclouds.azurecompute.arm.domain.Image;
import org.jclouds.azurecompute.arm.domain.ImageProperties;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_Image
extends Image {
    private final String id;
    private final String name;
    private final String location;
    private final ImageProperties properties;
    private final Map<String, String> tags;

    private AutoValue_Image(@Nullable String id, @Nullable String name, String location, ImageProperties properties, @Nullable Map<String, String> tags) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.properties = properties;
        this.tags = tags;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public ImageProperties properties() {
        return this.properties;
    }

    @Override
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    public String toString() {
        return "Image{id=" + this.id + ", name=" + this.name + ", location=" + this.location + ", properties=" + this.properties + ", tags=" + this.tags + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Image) {
            Image that = (Image)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.name == null ? that.name() == null : this.name.equals(that.name())) && this.location.equals(that.location()) && this.properties.equals(that.properties()) && (this.tags == null ? that.tags() == null : this.tags.equals(that.tags()));
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.id == null ? 0 : this.id.hashCode();
        h2 *= 1000003;
        h2 ^= this.name == null ? 0 : this.name.hashCode();
        h2 *= 1000003;
        h2 ^= this.location.hashCode();
        h2 *= 1000003;
        h2 ^= this.properties.hashCode();
        h2 *= 1000003;
        return h2 ^= this.tags == null ? 0 : this.tags.hashCode();
    }

    @Override
    public Image.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Image.Builder {
        private String id;
        private String name;
        private String location;
        private ImageProperties properties;
        private Map<String, String> tags;

        Builder() {
        }

        private Builder(Image source) {
            this.id = source.id();
            this.name = source.name();
            this.location = source.location();
            this.properties = source.properties();
            this.tags = source.tags();
        }

        @Override
        public Image.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public Image.Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public Image.Builder location(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public Image.Builder properties(ImageProperties properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = properties;
            return this;
        }

        @Override
        public Image.Builder tags(@Nullable Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        @Nullable
        Map<String, String> tags() {
            return this.tags;
        }

        @Override
        Image autoBuild() {
            String missing = "";
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.properties == null) {
                missing = missing + " properties";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Image(this.id, this.name, this.location, this.properties, this.tags);
        }
    }
}

