/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.handlers;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.handlers.AzureRetryableErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.handlers.RateLimitRetryHandler;

@Singleton
@Beta
public class AzureRateLimitRetryHandler
extends RateLimitRetryHandler {
    private final AzureRetryableErrorHandler retryableErrorHandler;

    @Inject
    AzureRateLimitRetryHandler(AzureRetryableErrorHandler retryableErrorHandler) {
        this.retryableErrorHandler = retryableErrorHandler;
    }

    @Override
    protected boolean delayRequestUntilAllowed(HttpCommand command, HttpResponse response) {
        if (!AzureRateLimitRetryHandler.isRateLimitError(response)) {
            return this.retryableErrorHandler.shouldRetryRequest(command, response);
        }
        return super.delayRequestUntilAllowed(command, response);
    }

    @Override
    protected Optional<Long> millisToNextAvailableRequest(HttpCommand command, HttpResponse response) {
        String secondsToNextAvailableRequest = response.getFirstHeaderOrNull("Retry-After");
        return secondsToNextAvailableRequest != null ? Optional.of(Long.parseLong(secondsToNextAvailableRequest) * 1000L) : Optional.absent();
    }

    public static boolean isRateLimitError(HttpResponse response) {
        return response.getFirstHeaderOrNull("Retry-After") != null;
    }
}

