/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.handlers;

import com.google.common.annotations.Beta;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.domain.Error;
import org.jclouds.azurecompute.arm.handlers.AzureRateLimitRetryHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

@Singleton
@Beta
public class AzureRetryableErrorHandler
extends BackoffLimitedRetryHandler {
    private static final String RETRYABLE_ERROR_CODE = "RetryableError";
    @Resource
    protected Logger logger = Logger.NULL;
    private final ParseJson<Error> parseError;

    @Inject
    AzureRetryableErrorHandler(ParseJson<Error> parseError) {
        this.parseError = parseError;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (response.getStatusCode() != 429 || AzureRateLimitRetryHandler.isRateLimitError(response)) {
            return false;
        }
        try {
            Error error = this.parseError.apply(response);
            this.logger.debug("processing error: %s", error);
            boolean isRetryable = RETRYABLE_ERROR_CODE.equals(error.details().code());
            return isRetryable ? super.shouldRetryRequest(command, response) : false;
        }
        catch (Exception ex) {
            this.logger.warn("could not parse error. Request won't be retried: %s", ex.getMessage());
            return false;
        }
    }
}

