/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.digitalocean2.domain.internal.AutoValue_PaginatedCollection_Links;
import org.jclouds.digitalocean2.domain.internal.AutoValue_PaginatedCollection_Links_Pages;
import org.jclouds.digitalocean2.domain.internal.AutoValue_PaginatedCollection_Meta;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class PaginatedCollection<T>
extends IterableWithMarker<T> {
    private final List<T> items;
    private final Meta meta;
    private final Links links;

    protected PaginatedCollection(List<T> items, Meta meta, Links links) {
        this.items = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(items, "items cannot be null"));
        this.meta = Preconditions.checkNotNull(meta, "meta cannot be null");
        this.links = Preconditions.checkNotNull(links, "links cannot be null");
    }

    public List<T> items() {
        return this.items;
    }

    public Meta meta() {
        return this.meta;
    }

    public Links links() {
        return this.links;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public Optional<Object> nextMarker() {
        if (this.links.pages() == null) {
            return Optional.absent();
        }
        return Optional.fromNullable(this.links.pages().next());
    }

    public static abstract class Links {
        @Nullable
        public abstract Pages pages();

        @SerializedNames(value={"pages"})
        public static Links create(Pages pages) {
            return new AutoValue_PaginatedCollection_Links(pages);
        }

        Links() {
        }

        public static abstract class Pages {
            @Nullable
            public abstract URI first();

            @Nullable
            public abstract URI prev();

            @Nullable
            public abstract URI next();

            @Nullable
            public abstract URI last();

            @SerializedNames(value={"first", "prev", "next", "last"})
            public static Pages create(URI first, URI prev, URI next, URI last) {
                return new AutoValue_PaginatedCollection_Links_Pages(first, prev, next, last);
            }

            Pages() {
            }
        }
    }

    public static abstract class Meta {
        public abstract long total();

        @SerializedNames(value={"total"})
        public static Meta create(long total) {
            return new AutoValue_PaginatedCollection_Meta(total);
        }

        Meta() {
        }
    }
}

