/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.beans.ConstructorProperties;

public class ErrorResponse
implements Comparable<ErrorResponse> {
    private final String message;
    private final String errorCode;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromErrorResponse(this);
    }

    @ConstructorProperties(value={"message", "errorcode"})
    protected ErrorResponse(String message, String errorCode) {
        this.message = Preconditions.checkNotNull(message, "message");
        this.errorCode = Preconditions.checkNotNull(errorCode, "errorCode");
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int hashCode() {
        return Objects.hashCode(this.message, this.errorCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorResponse that = (ErrorResponse)ErrorResponse.class.cast(obj);
        return Objects.equal(this.message, that.message) && Objects.equal(this.errorCode, that.errorCode);
    }

    @Override
    public int compareTo(ErrorResponse that) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.errorCode), (Comparable<?>)((Object)that.errorCode)).compare((Comparable<?>)((Object)this.message), (Comparable<?>)((Object)that.message)).result();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("message", this.message).add("errorCode", this.errorCode);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String message;
        protected String errorCode;

        protected abstract T self();

        public T message(String message) {
            this.message = message;
            return this.self();
        }

        public T errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this.self();
        }

        public ErrorResponse build() {
            return new ErrorResponse(this.message, this.errorCode);
        }

        public T fromErrorResponse(ErrorResponse in) {
            return ((Builder)this.message(in.getMessage())).errorCode(in.getErrorCode());
        }
    }
}

