/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloud.internal;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import org.jclouds.googlecloud.domain.ListPage;

final class AdvancingIterator<T>
extends AbstractIterator<ListPage<T>> {
    private final Function<String, ListPage<T>> tokenToNext;
    private ListPage<T> current;
    private boolean unread = true;

    AdvancingIterator(ListPage<T> initial, Function<String, ListPage<T>> tokenToNext) {
        this.current = initial;
        this.tokenToNext = tokenToNext;
    }

    @Override
    protected ListPage<T> computeNext() {
        if (this.unread) {
            try {
                ListPage<T> listPage = this.current;
                return listPage;
            }
            finally {
                this.unread = false;
            }
        }
        if (this.current.nextPageToken() != null) {
            this.current = this.tokenToNext.apply(this.current.nextPageToken());
            return this.current;
        }
        return (ListPage)this.endOfData();
    }
}

