/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.inject.Named;
import org.jclouds.crypto.Pems;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.domain.CertificateFingerprint;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;

@Singleton
final class CertificateFingerprintSupplier
implements Supplier<CertificateFingerprint> {
    private final Supplier<Credentials> creds;
    private final LoadingCache<Credentials, CertificateFingerprint> certCache;

    @Inject
    CertificateFingerprintSupplier(@Provider Supplier<Credentials> creds, CertificateFingerprintForCredentials loader) {
        this.creds = creds;
        this.certCache = CacheBuilder.newBuilder().maximumSize(2L).build(Preconditions.checkNotNull(loader, "loader"));
    }

    @Override
    public CertificateFingerprint get() {
        try {
            return this.certCache.getUnchecked(Preconditions.checkNotNull(this.creds.get(), "credential supplier returned null"));
        }
        catch (UncheckedExecutionException e) {
            AuthorizationException authorizationException = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
            if (authorizationException != null) {
                throw authorizationException;
            }
            throw e;
        }
    }

    @VisibleForTesting
    static final class CertificateFingerprintForCredentials
    extends CacheLoader<Credentials, CertificateFingerprint> {
        @Inject(optional=true)
        @Named(value="jclouds.oauth.certificate")
        String certInPemFormat;

        CertificateFingerprintForCredentials() {
        }

        @Override
        public CertificateFingerprint load(Credentials in) {
            try {
                if (this.certInPemFormat == null) {
                    throw new IllegalArgumentException("certificate not specified.");
                }
                X509Certificate cert = null;
                cert = Pems.x509Certificate(this.certInPemFormat);
                byte[] encodedCert = cert.getEncoded();
                HashCode hash = Hashing.sha1().hashBytes(encodedCert);
                String fingerprint = BaseEncoding.base64().encode(hash.asBytes());
                return CertificateFingerprint.create(fingerprint, cert);
            }
            catch (CertificateException e) {
                throw new AssertionError((Object)e);
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            catch (IllegalArgumentException e) {
                throw new AuthorizationException("cannot parse cert. " + e.getMessage(), e);
            }
        }
    }
}

