/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.openstack.neutron.v2.domain.Network;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;

public class Networks
extends PaginatedCollection<Network> {
    public static final Networks EMPTY = new Networks((Iterable<Network>)ImmutableSet.of(), (Iterable<Link>)ImmutableSet.of());

    @ConstructorProperties(value={"networks", "networks_links"})
    protected Networks(Iterable<Network> networks, Iterable<Link> networksLinks) {
        super(networks, networksLinks);
    }

    public static class Predicates {
        public static Predicate<Network> externalNetworks(final String availabilityZone) {
            return new Predicate<Network>(){

                @Override
                public boolean apply(Network network) {
                    return availabilityZone.equals(network.getAvailabilityZone()) && network.getExternal() != false;
                }
            };
        }

        public static Predicate<Network> namedNetworks(final Set<String> names) {
            return new Predicate<Network>(){

                @Override
                public boolean apply(Network network) {
                    return names.contains(network.getName());
                }
            };
        }
    }
}

