/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.domain.Image;

public class ImageToOperatingSystem
implements Function<Image, OperatingSystem> {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("(([^ ]*) ([0-9.]+) ?.*)");
    public static final Pattern WINDOWS_PATTERN = Pattern.compile("Windows (.*) (x[86][64])");
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    public ImageToOperatingSystem(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = osVersionMap;
    }

    @Override
    public OperatingSystem apply(Image from) {
        OsFamily osFamily = null;
        String osVersion = null;
        String imageName = MoreObjects.firstNonNull(from.getName(), "unspecified");
        boolean is64Bit = true;
        if (imageName.indexOf("Windows") != -1) {
            osFamily = OsFamily.WINDOWS;
            Matcher matcher = WINDOWS_PATTERN.matcher(from.getName());
            if (matcher.find()) {
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString(osFamily, matcher.group(1), this.osVersionMap);
                is64Bit = matcher.group(2).equals("x64");
            }
        } else {
            if (imageName.contains("Red Hat")) {
                osFamily = OsFamily.RHEL;
            } else if (imageName.contains("Oracle")) {
                osFamily = OsFamily.OEL;
            } else {
                final Iterable<String> imageNameParts = Splitter.on(CharMatcher.whitespace()).trimResults().split(imageName.toLowerCase());
                try {
                    osFamily = Iterables.find(Arrays.asList(OsFamily.values()), new Predicate<OsFamily>(){

                        @Override
                        public boolean apply(OsFamily osFamily) {
                            return Iterables.any(imageNameParts, Predicates.equalTo(osFamily.name().toLowerCase()));
                        }
                    });
                }
                catch (NoSuchElementException e) {
                    String ubuntuVersion = this.startsWithUbuntuVersion(imageNameParts);
                    if (ubuntuVersion != null) {
                        osFamily = OsFamily.UBUNTU;
                        osVersion = ubuntuVersion;
                    }
                    this.logger.trace("could not parse operating system family for image(%s): %s", from.getId(), imageNameParts);
                    osFamily = OsFamily.UNRECOGNIZED;
                }
            }
            Matcher matcher = DEFAULT_PATTERN.matcher(imageName);
            if (matcher.find() && matcher.groupCount() >= 3) {
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString(osFamily, matcher.group(3), this.osVersionMap);
            }
        }
        return new OperatingSystem(osFamily, imageName, osVersion, null, imageName, is64Bit);
    }

    String startsWithUbuntuVersion(Iterable<String> imageNameParts) {
        Map<String, String> ubuntuVersions = this.osVersionMap.get((Object)OsFamily.UBUNTU);
        for (String ubuntuKey : Iterables.filter(ubuntuVersions.keySet(), Predicates.not(Predicates.equalTo("")))) {
            if (!Iterables.any(imageNameParts, Predicates.containsPattern("^" + ubuntuKey + ".*"))) continue;
            return ubuntuVersions.get(ubuntuKey);
        }
        return null;
    }
}

