/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;

public class SecurityGroup {
    private final String id;
    @Named(value="tenant_id")
    private final String tenantId;
    private final String name;
    private final String description;
    private final Set<SecurityGroupRule> rules;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSecurityGroup(this);
    }

    @ConstructorProperties(value={"id", "tenant_id", "name", "description", "rules"})
    protected SecurityGroup(String id, @Nullable String tenantId, @Nullable String name, @Nullable String description, Set<SecurityGroupRule> rules) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.rules = Preconditions.checkNotNull(rules, "rules").isEmpty() ? null : ImmutableSet.copyOf(rules);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Set<SecurityGroupRule> getRules() {
        return this.rules;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.tenantId, this.name, this.description, this.rules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroup that = (SecurityGroup)SecurityGroup.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.rules, that.rules);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("name", this.name).add("description", this.description).add("rules", this.rules);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String tenantId;
        protected String name;
        protected String description;
        protected Set<SecurityGroupRule> rules = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T rules(Set<SecurityGroupRule> rules) {
            this.rules = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(rules, "rules"));
            return this.self();
        }

        public T rules(SecurityGroupRule ... in) {
            return this.rules(ImmutableSet.copyOf(in));
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.id, this.tenantId, this.name, this.description, this.rules);
        }

        public T fromSecurityGroup(SecurityGroup in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).tenantId(in.getTenantId())).name(in.getName())).description(in.getDescription())).rules(in.getRules());
        }
    }
}

