/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class SimpleServerUsage {
    @Named(value="name")
    private final String instanceName;
    private final double hours;
    @Named(value="memory_mb")
    private final double flavorMemoryMb;
    @Named(value="local_gb")
    private final double flavorLocalGb;
    @Named(value="vcpus")
    private final double flavorVcpus;
    @Named(value="tenant_id")
    private final String tenantId;
    @Named(value="flavor")
    private final String flavorName;
    @Named(value="started_at")
    private final Date instanceCreated;
    @Named(value="ended_at")
    private final Date instanceTerminated;
    @Named(value="state")
    private final Status instanceStatus;
    private final long uptime;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSimpleServerUsage(this);
    }

    @ConstructorProperties(value={"name", "hours", "memory_mb", "local_gb", "vcpus", "tenant_id", "flavor", "started_at", "ended_at", "state", "uptime"})
    protected SimpleServerUsage(String instanceName, double hours, double flavorMemoryMb, double flavorLocalGb, double flavorVcpus, String tenantId, String flavorName, Date instanceCreated, @Nullable Date instanceTerminated, Status instanceStatus, long uptime) {
        this.instanceName = Preconditions.checkNotNull(instanceName, "instanceName");
        this.hours = hours;
        this.flavorMemoryMb = flavorMemoryMb;
        this.flavorLocalGb = flavorLocalGb;
        this.flavorVcpus = flavorVcpus;
        this.tenantId = Preconditions.checkNotNull(tenantId, "tenantId");
        this.flavorName = Preconditions.checkNotNull(flavorName, "flavorName");
        this.instanceCreated = Preconditions.checkNotNull(instanceCreated, "instanceCreated");
        this.instanceTerminated = instanceTerminated;
        this.instanceStatus = Preconditions.checkNotNull(instanceStatus, "instanceStatus");
        this.uptime = uptime;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public double getHours() {
        return this.hours;
    }

    public double getFlavorMemoryMb() {
        return this.flavorMemoryMb;
    }

    public double getFlavorLocalGb() {
        return this.flavorLocalGb;
    }

    public double getFlavorVcpus() {
        return this.flavorVcpus;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public Date getInstanceCreated() {
        return this.instanceCreated;
    }

    @Nullable
    public Date getInstanceTerminated() {
        return this.instanceTerminated;
    }

    public Status getInstanceStatus() {
        return this.instanceStatus;
    }

    public long getUptime() {
        return this.uptime;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.instanceName, this.hours, this.flavorMemoryMb, this.flavorLocalGb, this.flavorVcpus, this.tenantId, this.flavorName, this.instanceCreated, this.instanceTerminated, this.instanceStatus, this.uptime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleServerUsage that = (SimpleServerUsage)SimpleServerUsage.class.cast(obj);
        return Objects.equal(this.instanceName, that.instanceName) && Objects.equal(this.hours, that.hours) && Objects.equal(this.flavorMemoryMb, that.flavorMemoryMb) && Objects.equal(this.flavorLocalGb, that.flavorLocalGb) && Objects.equal(this.flavorVcpus, that.flavorVcpus) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.flavorName, that.flavorName) && Objects.equal(this.instanceCreated, that.instanceCreated) && Objects.equal(this.instanceTerminated, that.instanceTerminated) && Objects.equal((Object)this.instanceStatus, (Object)that.instanceStatus) && Objects.equal(this.uptime, that.uptime);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("instanceName", this.instanceName).add("hours", this.hours).add("flavorMemoryMb", this.flavorMemoryMb).add("flavorLocalGb", this.flavorLocalGb).add("flavorVcpus", this.flavorVcpus).add("tenantId", this.tenantId).add("flavorName", this.flavorName).add("instanceCreated", this.instanceCreated).add("instanceTerminated", this.instanceTerminated).add("instanceStatus", (Object)this.instanceStatus).add("uptime", this.uptime);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String instanceName;
        protected double hours;
        protected double flavorMemoryMb;
        protected double flavorLocalGb;
        protected double flavorVcpus;
        protected String tenantId;
        protected String flavorName;
        protected Date instanceCreated;
        protected Date instanceTerminated;
        protected Status instanceStatus;
        protected long uptime;

        protected abstract T self();

        public T instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this.self();
        }

        public T hours(double hours) {
            this.hours = hours;
            return this.self();
        }

        public T flavorMemoryMb(double flavorMemoryMb) {
            this.flavorMemoryMb = flavorMemoryMb;
            return this.self();
        }

        public T flavorLocalGb(double flavorLocalGb) {
            this.flavorLocalGb = flavorLocalGb;
            return this.self();
        }

        public T flavorVcpus(double flavorVcpus) {
            this.flavorVcpus = flavorVcpus;
            return this.self();
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T flavorName(String flavorName) {
            this.flavorName = flavorName;
            return this.self();
        }

        public T instanceCreated(Date instanceCreated) {
            this.instanceCreated = instanceCreated;
            return this.self();
        }

        public T instanceTerminated(Date instanceTerminated) {
            this.instanceTerminated = instanceTerminated;
            return this.self();
        }

        public T instanceStatus(Status instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this.self();
        }

        public T uptime(long uptime) {
            this.uptime = uptime;
            return this.self();
        }

        public SimpleServerUsage build() {
            return new SimpleServerUsage(this.instanceName, this.hours, this.flavorMemoryMb, this.flavorLocalGb, this.flavorVcpus, this.tenantId, this.flavorName, this.instanceCreated, this.instanceTerminated, this.instanceStatus, this.uptime);
        }

        public T fromSimpleServerUsage(SimpleServerUsage in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.instanceName(in.getInstanceName())).hours(in.getHours())).flavorMemoryMb(in.getFlavorMemoryMb())).flavorLocalGb(in.getFlavorLocalGb())).flavorVcpus(in.getFlavorVcpus())).tenantId(in.getTenantId())).flavorName(in.getFlavorName())).instanceCreated(in.getInstanceCreated())).instanceTerminated(in.getInstanceTerminated())).instanceStatus(in.getInstanceStatus())).uptime(in.getUptime());
        }
    }

    public static enum Status {
        UNRECOGNIZED,
        ACTIVE;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

