/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.regionscoped;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class RegionAndName {
    public static final Function<RegionAndName, String> NAME_FUNCTION = new Function<RegionAndName, String>(){

        @Override
        public String apply(RegionAndName input) {
            return input.getName();
        }
    };
    public static final Function<RegionAndName, String> REGION_FUNCTION = new Function<RegionAndName, String>(){

        @Override
        public String apply(RegionAndName input) {
            return input.getRegion();
        }
    };
    protected final String regionId;
    protected final String name;

    public static RegionAndName fromSlashEncoded(String name) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(name, "name"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "name must be in format regionId/name");
        return new RegionAndName(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static RegionAndName fromRegionAndName(String regionId, String name) {
        return new RegionAndName(regionId, name);
    }

    private static String slashEncodeRegionAndName(String regionId, String name) {
        return Preconditions.checkNotNull(regionId, "regionId") + "/" + Preconditions.checkNotNull(name, "name");
    }

    public String slashEncode() {
        return RegionAndName.slashEncodeRegionAndName(this.regionId, this.name);
    }

    protected RegionAndName(String regionId, String name) {
        this.regionId = Preconditions.checkNotNull(regionId, "regionId");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public String getRegion() {
        return this.regionId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionAndName that = (RegionAndName)RegionAndName.class.cast(o);
        return Objects.equal(this.regionId, that.regionId) && Objects.equal(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.regionId, this.name);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("regionId", this.regionId).add("name", this.name);
    }

    public String toString() {
        return this.string().toString();
    }
}

