/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import java.util.Date;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Storage;

final class AutoValue_Storage
extends Storage {
    private final String id;
    private final String name;
    private final float size;
    private final Date creationTime;
    private final Date lastModificationTime;
    private final ProvisioningState state;
    private final List<String> serverIds;
    private final Boolean bootDevice;
    private final Storage.BusType busType;
    private final Integer deviceNumber;

    private AutoValue_Storage(String id, @Nullable String name, float size, @Nullable Date creationTime, @Nullable Date lastModificationTime, @Nullable ProvisioningState state, @Nullable List<String> serverIds, @Nullable Boolean bootDevice, @Nullable Storage.BusType busType, @Nullable Integer deviceNumber) {
        this.id = id;
        this.name = name;
        this.size = size;
        this.creationTime = creationTime;
        this.lastModificationTime = lastModificationTime;
        this.state = state;
        this.serverIds = serverIds;
        this.bootDevice = bootDevice;
        this.busType = busType;
        this.deviceNumber = deviceNumber;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public float size() {
        return this.size;
    }

    @Override
    @Nullable
    public Date creationTime() {
        return this.creationTime;
    }

    @Override
    @Nullable
    public Date lastModificationTime() {
        return this.lastModificationTime;
    }

    @Override
    @Nullable
    public ProvisioningState state() {
        return this.state;
    }

    @Override
    @Nullable
    public List<String> serverIds() {
        return this.serverIds;
    }

    @Override
    @Nullable
    public Boolean bootDevice() {
        return this.bootDevice;
    }

    @Override
    @Nullable
    public Storage.BusType busType() {
        return this.busType;
    }

    @Override
    @Nullable
    public Integer deviceNumber() {
        return this.deviceNumber;
    }

    public String toString() {
        return "Storage{id=" + this.id + ", name=" + this.name + ", size=" + this.size + ", creationTime=" + this.creationTime + ", lastModificationTime=" + this.lastModificationTime + ", state=" + (Object)((Object)this.state) + ", serverIds=" + this.serverIds + ", bootDevice=" + this.bootDevice + ", busType=" + (Object)((Object)this.busType) + ", deviceNumber=" + this.deviceNumber + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Storage) {
            Storage that = (Storage)o;
            return this.id.equals(that.id()) && (this.name == null ? that.name() == null : this.name.equals(that.name())) && Float.floatToIntBits(this.size) == Float.floatToIntBits(that.size()) && (this.creationTime == null ? that.creationTime() == null : this.creationTime.equals(that.creationTime())) && (this.lastModificationTime == null ? that.lastModificationTime() == null : this.lastModificationTime.equals(that.lastModificationTime())) && (this.state == null ? that.state() == null : this.state.equals((Object)that.state())) && (this.serverIds == null ? that.serverIds() == null : this.serverIds.equals(that.serverIds())) && (this.bootDevice == null ? that.bootDevice() == null : this.bootDevice.equals(that.bootDevice())) && (this.busType == null ? that.busType() == null : this.busType.equals((Object)that.busType())) && (this.deviceNumber == null ? that.deviceNumber() == null : this.deviceNumber.equals(that.deviceNumber()));
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.id.hashCode();
        h2 *= 1000003;
        h2 ^= this.name == null ? 0 : this.name.hashCode();
        h2 *= 1000003;
        h2 ^= Float.floatToIntBits(this.size);
        h2 *= 1000003;
        h2 ^= this.creationTime == null ? 0 : this.creationTime.hashCode();
        h2 *= 1000003;
        h2 ^= this.lastModificationTime == null ? 0 : this.lastModificationTime.hashCode();
        h2 *= 1000003;
        h2 ^= this.state == null ? 0 : this.state.hashCode();
        h2 *= 1000003;
        h2 ^= this.serverIds == null ? 0 : this.serverIds.hashCode();
        h2 *= 1000003;
        h2 ^= this.bootDevice == null ? 0 : this.bootDevice.hashCode();
        h2 *= 1000003;
        h2 ^= this.busType == null ? 0 : this.busType.hashCode();
        h2 *= 1000003;
        return h2 ^= this.deviceNumber == null ? 0 : this.deviceNumber.hashCode();
    }

    @Override
    public Storage.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Storage.Builder {
        private String id;
        private String name;
        private Float size;
        private Date creationTime;
        private Date lastModificationTime;
        private ProvisioningState state;
        private List<String> serverIds;
        private Boolean bootDevice;
        private Storage.BusType busType;
        private Integer deviceNumber;

        Builder() {
        }

        private Builder(Storage source) {
            this.id = source.id();
            this.name = source.name();
            this.size = Float.valueOf(source.size());
            this.creationTime = source.creationTime();
            this.lastModificationTime = source.lastModificationTime();
            this.state = source.state();
            this.serverIds = source.serverIds();
            this.bootDevice = source.bootDevice();
            this.busType = source.busType();
            this.deviceNumber = source.deviceNumber();
        }

        @Override
        public Storage.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public Storage.Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public Storage.Builder size(float size) {
            this.size = Float.valueOf(size);
            return this;
        }

        @Override
        public Storage.Builder creationTime(@Nullable Date creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Storage.Builder lastModificationTime(@Nullable Date lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public Storage.Builder state(@Nullable ProvisioningState state) {
            this.state = state;
            return this;
        }

        @Override
        public Storage.Builder serverIds(@Nullable List<String> serverIds) {
            this.serverIds = serverIds;
            return this;
        }

        @Override
        public Storage.Builder bootDevice(@Nullable Boolean bootDevice) {
            this.bootDevice = bootDevice;
            return this;
        }

        @Override
        public Storage.Builder busType(@Nullable Storage.BusType busType) {
            this.busType = busType;
            return this;
        }

        @Override
        public Storage.Builder deviceNumber(@Nullable Integer deviceNumber) {
            this.deviceNumber = deviceNumber;
            return this;
        }

        @Override
        Storage autoBuild() {
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.size == null) {
                missing = missing + " size";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Storage(this.id, this.name, this.size.floatValue(), this.creationTime, this.lastModificationTime, this.state, this.serverIds, this.bootDevice, this.busType, this.deviceNumber);
        }
    }
}

