/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.common.base.Enums;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_ServiceFault;
import org.jclouds.profitbricks.domain.AutoValue_ServiceFault_Details;

public abstract class ServiceFault {
    public abstract String faultCode();

    public abstract String faultString();

    @Nullable
    public abstract Details details();

    public static Builder builder() {
        return new AutoValue_ServiceFault.Builder();
    }

    public static abstract class Details {
        public abstract FaultCode faultCode();

        public abstract int httpCode();

        public abstract String message();

        public abstract int requestId();

        public static Builder builder() {
            return new AutoValue_ServiceFault_Details.Builder();
        }

        public static abstract class Builder {
            public abstract Builder faultCode(FaultCode var1);

            public abstract Builder httpCode(int var1);

            public abstract Builder message(String var1);

            public abstract Builder requestId(int var1);

            public abstract Details build();
        }

        public static enum FaultCode {
            BAD_REQUEST,
            UNEXPECTED,
            UNAUTHORIZED,
            RESOURCE_NOT_FOUND,
            RESOURCE_DELETED,
            PROVISIONING_IN_PROCESS,
            PROVISIONING_NO_CHANGES,
            OVER_LIMIT_SETTING,
            SERVER_EXCEED_CAPACITY,
            SERVICE_UNAVAILABLE,
            UNRECOGNIZED;


            public static FaultCode fromValue(String v) {
                return Enums.getIfPresent(FaultCode.class, v).or(UNRECOGNIZED);
            }
        }
    }

    public static abstract class Builder {
        public abstract Builder faultCode(String var1);

        public abstract Builder faultString(String var1);

        public abstract Builder details(Details var1);

        public abstract ServiceFault build();
    }
}

