/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.DeploymentTemplate;
import org.jclouds.azurecompute.arm.domain.ResourceDefinition;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_DeploymentTemplate
extends DeploymentTemplate {
    private final String schema;
    private final String contentVersion;
    private final DeploymentTemplate.TemplateParameters parameters;
    private final Map<String, String> variables;
    private final List<ResourceDefinition> resources;
    private final List<?> outputs;

    private AutoValue_DeploymentTemplate(String schema, String contentVersion, DeploymentTemplate.TemplateParameters parameters, Map<String, String> variables, List<ResourceDefinition> resources, @Nullable List<?> outputs) {
        this.schema = schema;
        this.contentVersion = contentVersion;
        this.parameters = parameters;
        this.variables = variables;
        this.resources = resources;
        this.outputs = outputs;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public String contentVersion() {
        return this.contentVersion;
    }

    @Override
    public DeploymentTemplate.TemplateParameters parameters() {
        return this.parameters;
    }

    @Override
    public Map<String, String> variables() {
        return this.variables;
    }

    @Override
    public List<ResourceDefinition> resources() {
        return this.resources;
    }

    @Override
    @Nullable
    public List<?> outputs() {
        return this.outputs;
    }

    public String toString() {
        return "DeploymentTemplate{schema=" + this.schema + ", contentVersion=" + this.contentVersion + ", parameters=" + this.parameters + ", variables=" + this.variables + ", resources=" + this.resources + ", outputs=" + this.outputs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DeploymentTemplate) {
            DeploymentTemplate that = (DeploymentTemplate)o;
            return this.schema.equals(that.schema()) && this.contentVersion.equals(that.contentVersion()) && this.parameters.equals(that.parameters()) && this.variables.equals(that.variables()) && this.resources.equals(that.resources()) && (this.outputs == null ? that.outputs() == null : this.outputs.equals(that.outputs()));
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.schema.hashCode();
        h2 *= 1000003;
        h2 ^= this.contentVersion.hashCode();
        h2 *= 1000003;
        h2 ^= this.parameters.hashCode();
        h2 *= 1000003;
        h2 ^= this.variables.hashCode();
        h2 *= 1000003;
        h2 ^= this.resources.hashCode();
        h2 *= 1000003;
        return h2 ^= this.outputs == null ? 0 : this.outputs.hashCode();
    }

    @Override
    public DeploymentTemplate.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DeploymentTemplate.Builder {
        private String schema;
        private String contentVersion;
        private DeploymentTemplate.TemplateParameters parameters;
        private Map<String, String> variables;
        private List<ResourceDefinition> resources;
        private List<?> outputs;

        Builder() {
        }

        private Builder(DeploymentTemplate source) {
            this.schema = source.schema();
            this.contentVersion = source.contentVersion();
            this.parameters = source.parameters();
            this.variables = source.variables();
            this.resources = source.resources();
            this.outputs = source.outputs();
        }

        @Override
        public DeploymentTemplate.Builder schema(String schema) {
            if (schema == null) {
                throw new NullPointerException("Null schema");
            }
            this.schema = schema;
            return this;
        }

        @Override
        public DeploymentTemplate.Builder contentVersion(String contentVersion) {
            if (contentVersion == null) {
                throw new NullPointerException("Null contentVersion");
            }
            this.contentVersion = contentVersion;
            return this;
        }

        @Override
        public DeploymentTemplate.Builder parameters(DeploymentTemplate.TemplateParameters parameters) {
            if (parameters == null) {
                throw new NullPointerException("Null parameters");
            }
            this.parameters = parameters;
            return this;
        }

        @Override
        public DeploymentTemplate.Builder variables(Map<String, String> variables) {
            if (variables == null) {
                throw new NullPointerException("Null variables");
            }
            this.variables = variables;
            return this;
        }

        @Override
        Map<String, String> variables() {
            if (this.variables == null) {
                throw new IllegalStateException("Property \"variables\" has not been set");
            }
            return this.variables;
        }

        @Override
        public DeploymentTemplate.Builder resources(List<ResourceDefinition> resources) {
            if (resources == null) {
                throw new NullPointerException("Null resources");
            }
            this.resources = resources;
            return this;
        }

        @Override
        List<ResourceDefinition> resources() {
            if (this.resources == null) {
                throw new IllegalStateException("Property \"resources\" has not been set");
            }
            return this.resources;
        }

        @Override
        public DeploymentTemplate.Builder outputs(@Nullable List<?> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Override
        DeploymentTemplate autoBuild() {
            String missing = "";
            if (this.schema == null) {
                missing = missing + " schema";
            }
            if (this.contentVersion == null) {
                missing = missing + " contentVersion";
            }
            if (this.parameters == null) {
                missing = missing + " parameters";
            }
            if (this.variables == null) {
                missing = missing + " variables";
            }
            if (this.resources == null) {
                missing = missing + " resources";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DeploymentTemplate(this.schema, this.contentVersion, this.parameters, this.variables, this.resources, this.outputs);
        }
    }
}

