/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_MetricDefinition;
import org.jclouds.azurecompute.arm.domain.AutoValue_MetricDefinition_MetricAvailability;
import org.jclouds.azurecompute.arm.domain.MetricName;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class MetricDefinition {
    @Nullable
    public abstract String resourceId();

    public abstract MetricName name();

    @Nullable
    public abstract Boolean isDimensionRequired();

    public abstract String unit();

    public abstract AggregationType primaryAggregationType();

    public abstract List<MetricAvailability> metricAvailabilities();

    public abstract String id();

    @SerializedNames(value={"resourceId", "name", "isDimensionRequired", "unit", "primaryAggregationType", "metricAvailabilities", "id"})
    public static MetricDefinition create(String resourceId, MetricName name, Boolean isDimensionRequired, String unit, AggregationType primaryAggregationType, List<MetricAvailability> metricAvailabilities, String id) {
        return new AutoValue_MetricDefinition(resourceId, name, isDimensionRequired, unit, primaryAggregationType, metricAvailabilities == null ? ImmutableList.of() : ImmutableList.copyOf(metricAvailabilities), id);
    }

    public static abstract class MetricAvailability {
        public abstract String timeGrain();

        public abstract String retention();

        MetricAvailability() {
        }

        @SerializedNames(value={"timeGrain", "retention"})
        public static MetricAvailability create(String timeGrain, String retention) {
            return new AutoValue_MetricDefinition_MetricAvailability(timeGrain, retention);
        }
    }

    public static enum AggregationType {
        None("None"),
        Average("Average"),
        Count("Count"),
        Total("Total"),
        Minimum("Minimum"),
        Maximum("Maximum"),
        UNRECOGNIZED("Unrecognized");

        private final String label;

        private AggregationType(String label) {
            this.label = label;
        }

        public static AggregationType fromValue(String text) {
            return (AggregationType)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }

        public String toString() {
            return this.label;
        }
    }
}

