/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.ZoneAndName;
import org.jclouds.cloudstack.domain.ZoneSecurityGroupNamePortsCidrs;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.cloudstack.predicates.SecurityGroupPredicates;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class CloudStackSecurityGroupExtension
implements SecurityGroupExtension {
    protected final CloudStackApi api;
    protected final Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> groupConverter;
    protected final LoadingCache<ZoneAndName, SecurityGroup> groupCreator;
    protected final GroupNamingConvention.Factory namingConvention;
    protected final Supplier<Set<? extends Location>> locations;
    protected final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    protected final Predicate<String> jobComplete;

    @Inject
    public CloudStackSecurityGroupExtension(CloudStackApi api, Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> groupConverter, LoadingCache<ZoneAndName, SecurityGroup> groupCreator, GroupNamingConvention.Factory namingConvention, @Memoized Supplier<Set<? extends Location>> locations, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, Predicate<String> jobComplete) {
        this.api = Preconditions.checkNotNull(api, "api");
        this.groupConverter = Preconditions.checkNotNull(groupConverter, "groupConverter");
        this.groupCreator = Preconditions.checkNotNull(groupCreator, "groupCreator");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.blockUntilJobCompletesAndReturnResult = Preconditions.checkNotNull(blockUntilJobCompletesAndReturnResult, "blockUntilJobCompletesAndReturnResult");
        this.jobComplete = Preconditions.checkNotNull(jobComplete, "jobComplete");
    }

    @Override
    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroups() {
        Set<SecurityGroup> rawGroups = this.api.getSecurityGroupApi().listSecurityGroups(new ListSecurityGroupsOptions[0]);
        Iterable<org.jclouds.compute.domain.SecurityGroup> groups = Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf(groups);
    }

    @Override
    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsInLocation(Location location) {
        return this.listSecurityGroups();
    }

    @Override
    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsForNode(String id) {
        Preconditions.checkNotNull(id, "id");
        Set<SecurityGroup> rawGroups = this.api.getSecurityGroupApi().listSecurityGroups(ListSecurityGroupsOptions.Builder.virtualMachineId(id));
        Iterable<org.jclouds.compute.domain.SecurityGroup> groups = Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf(groups);
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup getSecurityGroupById(String id) {
        Preconditions.checkNotNull(id, "id");
        SecurityGroup rawGroup = this.api.getSecurityGroupApi().getSecurityGroup(id);
        if (rawGroup == null) {
            return null;
        }
        return this.groupConverter.apply(rawGroup);
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup createSecurityGroup(String name, Location location) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(location, "location");
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        ZoneSecurityGroupNamePortsCidrs zoneAndName = ((ZoneSecurityGroupNamePortsCidrs.Builder)((ZoneSecurityGroupNamePortsCidrs.Builder)ZoneSecurityGroupNamePortsCidrs.builder().zone(location.getId())).name(markerGroup)).build();
        return this.groupConverter.apply(this.groupCreator.getUnchecked(zoneAndName));
    }

    @Override
    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull(id, "id");
        SecurityGroup group = this.api.getSecurityGroupApi().getSecurityGroup(id);
        if (group == null) {
            this.invalidateCache(id);
            return false;
        }
        for (IngressRule rule : group.getIngressRules()) {
            this.jobComplete.apply(this.api.getSecurityGroupApi().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0]));
        }
        this.api.getSecurityGroupApi().deleteSecurityGroup(id);
        this.invalidateCache(id);
        return true;
    }

    private void invalidateCache(String id) {
        for (Map.Entry sg : this.groupCreator.asMap().entrySet()) {
            if (!id.equals(((SecurityGroup)sg.getValue()).getId())) continue;
            this.groupCreator.invalidate(sg.getKey());
            break;
        }
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        Preconditions.checkNotNull(group, "group");
        Preconditions.checkNotNull(ipPermission, "ipPermission");
        String id = Preconditions.checkNotNull(group.getId(), "group.getId()");
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            this.jobComplete.apply(this.api.getSecurityGroupApi().authorizeIngressPortsToCIDRs(id, ipPermission.getIpProtocol().toString().toUpperCase(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getCidrBlocks(), new AccountInDomainOptions[0]));
        }
        if (!ipPermission.getTenantIdGroupNamePairs().isEmpty()) {
            this.jobComplete.apply(this.api.getSecurityGroupApi().authorizeIngressPortsToSecurityGroups(id, ipPermission.getIpProtocol().toString().toUpperCase(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getTenantIdGroupNamePairs(), new AccountInDomainOptions[0]));
        }
        return this.getSecurityGroupById(id);
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.addIpPermission(permBuilder.build(), group);
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        Preconditions.checkNotNull(group, "group");
        Preconditions.checkNotNull(ipPermission, "ipPermission");
        String id = Preconditions.checkNotNull(group.getId(), "group.getId()");
        SecurityGroup rawGroup = this.api.getSecurityGroupApi().getSecurityGroup(id);
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (IngressRule rule : Iterables.filter(rawGroup.getIngressRules(), SecurityGroupPredicates.ruleCidrMatches(ipPermission.getIpProtocol().toString(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getCidrBlocks()))) {
                this.jobComplete.apply(this.api.getSecurityGroupApi().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0]));
            }
        }
        if (!ipPermission.getTenantIdGroupNamePairs().isEmpty()) {
            for (IngressRule rule : Iterables.filter(rawGroup.getIngressRules(), SecurityGroupPredicates.ruleGroupMatches(ipPermission.getIpProtocol().toString(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getTenantIdGroupNamePairs()))) {
                this.jobComplete.apply(this.api.getSecurityGroupApi().revokeIngressRule(rule.getId(), new AccountInDomainOptions[0]));
            }
        }
        return this.getSecurityGroupById(id);
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    @Override
    public boolean supportsTenantIdGroupNamePairs() {
        return true;
    }

    @Override
    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    @Override
    public boolean supportsGroupIds() {
        return false;
    }

    @Override
    public boolean supportsPortRangesForGroups() {
        return false;
    }

    @Override
    public boolean supportsExclusionCidrBlocks() {
        return false;
    }
}

