/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.options;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;

public class CloudStackTemplateOptions
extends TemplateOptions
implements Cloneable {
    private Set<String> securityGroupIds = ImmutableSet.of();
    private Map<String, String> ipsToNetworks = ImmutableMap.of();
    private String ipOnDefaultNetwork;
    private String keyPair;
    private boolean setupStaticNat = true;
    private String account;
    private String domainId;
    private boolean generateKeyPair = false;
    private boolean generateSecurityGroup = false;
    private String diskOfferingId;
    private int dataDiskSize;
    private byte[] userData;

    public CloudStackTemplateOptions securityGroupIds(Iterable<String> securityGroupIds) {
        this.securityGroupIds = ImmutableSet.copyOf(securityGroupIds);
        return this;
    }

    public CloudStackTemplateOptions ipsToNetworks(Map<String, String> ipsToNetworks) {
        this.ipsToNetworks = ImmutableMap.copyOf(ipsToNetworks);
        return this;
    }

    public CloudStackTemplateOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
        this.ipOnDefaultNetwork = ipOnDefaultNetwork;
        return this;
    }

    public CloudStackTemplateOptions keyPair(String keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
        this.setupStaticNat = setupStaticNat;
        return this;
    }

    public CloudStackTemplateOptions account(String account) {
        this.account = account;
        return this;
    }

    public CloudStackTemplateOptions domainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    public CloudStackTemplateOptions generateKeyPair(boolean generateKeyPair) {
        this.generateKeyPair = generateKeyPair;
        return this;
    }

    public CloudStackTemplateOptions generateSecurityGroup(boolean generateSecurityGroup) {
        this.generateSecurityGroup = generateSecurityGroup;
        return this;
    }

    public CloudStackTemplateOptions diskOfferingId(String diskOfferingId) {
        this.diskOfferingId = diskOfferingId;
        return this;
    }

    public CloudStackTemplateOptions dataDiskSize(int dataDiskSize) {
        this.dataDiskSize = dataDiskSize;
        return this;
    }

    public CloudStackTemplateOptions userData(byte[] userData) {
        this.userData = userData;
        return this;
    }

    public CloudStackTemplateOptions userData(String userData) {
        this.userData = Preconditions.checkNotNull(userData, "userdata").getBytes(Charsets.UTF_8);
        return this;
    }

    public CloudStackTemplateOptions userData(URL userDataUrl) throws IOException {
        this.userData = Resources.toString(Preconditions.checkNotNull(userDataUrl, "userDataUrl"), Charsets.UTF_8).getBytes(Charsets.UTF_8);
        return this;
    }

    public Set<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public Map<String, String> getIpsToNetworks() {
        return this.ipsToNetworks;
    }

    public String getIpOnDefaultNetwork() {
        return this.ipOnDefaultNetwork;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public boolean shouldSetupStaticNat() {
        return this.setupStaticNat;
    }

    public String getAccount() {
        return this.account;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public boolean shouldGenerateKeyPair() {
        return this.generateKeyPair;
    }

    public boolean shouldGenerateSecurityGroup() {
        return this.generateSecurityGroup;
    }

    public String getDiskOfferingId() {
        return this.diskOfferingId;
    }

    public int getDataDiskSize() {
        return this.dataDiskSize;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    @Override
    public CloudStackTemplateOptions clone() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof CloudStackTemplateOptions) {
            CloudStackTemplateOptions eTo = (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(to);
            eTo.securityGroupIds(this.securityGroupIds);
            eTo.ipsToNetworks(this.ipsToNetworks);
            eTo.ipOnDefaultNetwork(this.ipOnDefaultNetwork);
            eTo.keyPair(this.keyPair);
            eTo.generateKeyPair(this.generateKeyPair);
            eTo.generateSecurityGroup(this.generateSecurityGroup);
            eTo.account(this.account);
            eTo.domainId(this.domainId);
            eTo.setupStaticNat(this.setupStaticNat);
            eTo.diskOfferingId(this.diskOfferingId);
            eTo.dataDiskSize(this.dataDiskSize);
            eTo.userData(this.userData);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudStackTemplateOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudStackTemplateOptions that = (CloudStackTemplateOptions)o;
        return this.setupStaticNat == that.setupStaticNat && this.generateKeyPair == that.generateKeyPair && this.generateSecurityGroup == that.generateSecurityGroup && this.dataDiskSize == that.dataDiskSize && Objects.equal(this.securityGroupIds, that.securityGroupIds) && Objects.equal(this.ipsToNetworks, that.ipsToNetworks) && Objects.equal(this.ipOnDefaultNetwork, that.ipOnDefaultNetwork) && Objects.equal(this.keyPair, that.keyPair) && Objects.equal(this.account, that.account) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.diskOfferingId, that.diskOfferingId) && Arrays.equals(this.userData, that.userData);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.securityGroupIds, this.ipsToNetworks, this.ipOnDefaultNetwork, this.keyPair, this.setupStaticNat, this.account, this.domainId, this.generateKeyPair, this.generateSecurityGroup, this.diskOfferingId, this.dataDiskSize, Arrays.hashCode(this.userData));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("securityGroupIds", this.securityGroupIds).add("ipsToNetworks", this.ipsToNetworks).add("ipOnDefaultNetwork", this.ipOnDefaultNetwork).add("keyPair", this.keyPair).add("setupStaticNat", this.setupStaticNat).add("account", this.account).add("domainId", this.domainId).add("generateKeyPair", this.generateKeyPair).add("generateSecurityGroup", this.generateSecurityGroup).add("diskOfferingId", this.diskOfferingId).add("dataDiskSize", this.dataDiskSize).add("userData", this.userData).toString();
    }

    @Override
    public CloudStackTemplateOptions blockOnPort(int port, int seconds) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public CloudStackTemplateOptions inboundPorts(int ... ports) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public CloudStackTemplateOptions authorizePublicKey(String publicKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public CloudStackTemplateOptions installPrivateKey(String privateKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    public CloudStackTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    @Override
    public CloudStackTemplateOptions dontAuthorizePublicKey() {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    @Override
    public CloudStackTemplateOptions nameTask(String name) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public CloudStackTemplateOptions runAsRoot(boolean runAsRoot) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public CloudStackTemplateOptions runScript(Statement script) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    public CloudStackTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public CloudStackTemplateOptions overrideLoginPassword(String password) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public CloudStackTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public CloudStackTemplateOptions overrideLoginUser(String loginUser) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public CloudStackTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    @Override
    public CloudStackTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    @Override
    public CloudStackTemplateOptions userMetadata(String key, String value) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    @Override
    public CloudStackTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    @Override
    public CloudStackTemplateOptions networks(Iterable<String> networks) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static CloudStackTemplateOptions securityGroupIds(Iterable<String> securityGroupIds) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static CloudStackTemplateOptions ipsToNetworks(Map<String, String> ipToNetworkMap) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipsToNetworks(ipToNetworkMap);
        }

        public static CloudStackTemplateOptions ipOnDefaultNetwork(String ipAddress) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipOnDefaultNetwork(ipAddress);
        }

        public static CloudStackTemplateOptions keyPair(String keyPair) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.keyPair(keyPair);
        }

        public static CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.setupStaticNat(setupStaticNat);
        }

        public static CloudStackTemplateOptions account(String account) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.account(account);
        }

        public static CloudStackTemplateOptions domainId(String domainId) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.domainId(domainId);
        }

        public static CloudStackTemplateOptions generateKeyPair(boolean enable) {
            return new CloudStackTemplateOptions().generateKeyPair(enable);
        }

        public static CloudStackTemplateOptions generateSecurityGroup(boolean enable) {
            return new CloudStackTemplateOptions().generateSecurityGroup(enable);
        }

        public static CloudStackTemplateOptions diskOfferingId(String diskOfferingId) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.diskOfferingId(diskOfferingId);
        }

        public static CloudStackTemplateOptions dataDiskSize(int dataDiskSize) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.dataDiskSize(dataDiskSize);
        }

        public static CloudStackTemplateOptions userData(byte[] userData) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.userData(userData);
        }
    }
}

