/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.Volume;
import org.jclouds.javax.annotation.Nullable;

public class VolumeImpl
implements Volume {
    @Nullable
    private final String id;
    private final Volume.Type type;
    @Nullable
    private final Float size;
    @Nullable
    private final String device;
    private final boolean bootDevice;
    private final boolean durable;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeImpl that = (VolumeImpl)VolumeImpl.class.cast(o);
        return Objects.equal(this.id, that.id) && Objects.equal((Object)this.getType(), (Object)that.getType()) && Objects.equal(this.size, that.size) && Objects.equal(this.device, that.device) && Objects.equal(this.bootDevice, that.bootDevice) && Objects.equal(this.durable, that.durable);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.size, this.device, this.bootDevice, this.durable);
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("id", this.id).add("type", (Object)this.getType()).add("size", this.size).add("device", this.device).add("bootDevice", this.bootDevice).add("durable", this.durable);
    }

    public VolumeImpl(@Nullable String id, Volume.Type type, @Nullable Float size, @Nullable String device, boolean bootDevice, boolean durable) {
        this.id = id;
        this.type = Preconditions.checkNotNull(type, "type");
        this.size = size;
        this.device = device;
        this.bootDevice = bootDevice;
        this.durable = durable;
    }

    public VolumeImpl(@Nullable Float size, boolean bootDevice, boolean durable) {
        this(null, Volume.Type.LOCAL, size, null, bootDevice, durable);
    }

    public VolumeImpl(@Nullable Float size, @Nullable String device, boolean bootDevice, boolean durable) {
        this(null, Volume.Type.LOCAL, size, device, bootDevice, durable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Volume.Type getType() {
        return this.type;
    }

    @Override
    public Float getSize() {
        return this.size;
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public boolean isBootDevice() {
        return this.bootDevice;
    }
}

