/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.compute.options.DigitalOcean2TemplateOptions;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.DropletCreate;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.Size;
import org.jclouds.digitalocean2.domain.options.CreateDropletOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

public class DigitalOcean2ComputeServiceAdapter
implements ComputeServiceAdapter<Droplet, Size, ImageInRegion, Region> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOcean2Api api;
    private final Predicate<Integer> nodeRunningPredicate;
    private final Predicate<Integer> nodeStoppedPredicate;
    private final Predicate<Integer> nodeTerminatedPredicate;

    @Inject
    DigitalOcean2ComputeServiceAdapter(DigitalOcean2Api api, @Named(value="jclouds.compute.timeout.node-running") Predicate<Integer> nodeRunningPredicate, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<Integer> nodeStoppedPredicate, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<Integer> nodeTerminatedPredicate) {
        this.api = api;
        this.nodeRunningPredicate = nodeRunningPredicate;
        this.nodeStoppedPredicate = nodeStoppedPredicate;
        this.nodeTerminatedPredicate = nodeTerminatedPredicate;
    }

    private void setUserDataIfSupported(Template template, CreateDropletOptions.Builder options, String userData) {
        List regionFeatures = (List)template.getLocation().getMetadata().get("features");
        if (regionFeatures.contains("metadata")) {
            options.userData(userData);
        } else {
            this.logger.debug(">> region %s does not support metadata, ignoring provided user data", template.getLocation().getId());
        }
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Droplet> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        DigitalOcean2TemplateOptions templateOptions = template.getOptions().as(DigitalOcean2TemplateOptions.class);
        CreateDropletOptions.Builder options = CreateDropletOptions.builder();
        options.privateNetworking(templateOptions.getPrivateNetworking());
        options.backupsEnabled(templateOptions.getBackupsEnabled());
        if (!templateOptions.getSshKeyIds().isEmpty()) {
            options.addSshKeyIds(templateOptions.getSshKeyIds());
        }
        if (null != templateOptions.getUserData()) {
            this.setUserDataIfSupported(template, options, new String(templateOptions.getUserData()));
        } else if (null != templateOptions.getUserMetadata().get("user_data")) {
            this.setUserDataIfSupported(template, options, templateOptions.getUserMetadata().get("user_data"));
        }
        DropletCreate dropletCreated = this.api.dropletApi().create(name, template.getLocation().getId(), template.getHardware().getProviderId(), template.getImage().getProviderId(), options.build());
        this.nodeRunningPredicate.apply(dropletCreated.droplet().id());
        Droplet droplet = this.api.dropletApi().get(dropletCreated.droplet().id());
        LoginCredentials defaultCredentials = LoginCredentials.builder().user("root").privateKey(templateOptions.getLoginPrivateKey()).build();
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Droplet>(droplet, String.valueOf(droplet.id()), defaultCredentials);
    }

    @Override
    public Iterable<ImageInRegion> listImages() {
        final HashSet<String> availableRegionsIds = Sets.newHashSet(Iterables.transform(this.listLocations(), new Function<Region, String>(){

            @Override
            public String apply(Region input) {
                return input.slug();
            }
        }));
        return Iterables.concat(Iterables.filter(this.api.imageApi().list().concat().transform(new Function<Image, Iterable<ImageInRegion>>(){

            @Override
            public Iterable<ImageInRegion> apply(final Image image) {
                return Iterables.transform(image.regions(), new Function<String, ImageInRegion>(){

                    @Override
                    public ImageInRegion apply(String region) {
                        return availableRegionsIds.contains(region) ? ImageInRegion.create(image, region) : null;
                    }
                });
            }
        }), Predicates.notNull()));
    }

    @Override
    public Iterable<Size> listHardwareProfiles() {
        return Iterables.filter(this.api.sizeApi().list().concat(), new Predicate<Size>(){

            @Override
            public boolean apply(Size size) {
                return size.available();
            }
        });
    }

    @Override
    public Iterable<Region> listLocations() {
        return Iterables.filter(this.api.regionApi().list().concat(), new Predicate<Region>(){

            @Override
            public boolean apply(Region region) {
                return region.available();
            }
        });
    }

    @Override
    public Iterable<Droplet> listNodes() {
        return this.api.dropletApi().list().concat();
    }

    @Override
    public Iterable<Droplet> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), new Predicate<Droplet>(){

            @Override
            public boolean apply(Droplet droplet) {
                return Iterables.contains(ids, String.valueOf(droplet.id()));
            }
        });
    }

    @Override
    public ImageInRegion getImage(String id) {
        String region = ImageInRegion.extractRegion(id);
        String imageId = ImageInRegion.extractImageId(id);
        Integer numericId = Ints.tryParse(imageId);
        Image image = numericId == null ? this.api.imageApi().get(imageId) : this.api.imageApi().get(numericId);
        return image == null ? null : ImageInRegion.create(image, region);
    }

    @Override
    public Droplet getNode(String id) {
        return this.api.dropletApi().get(Integer.parseInt(id));
    }

    @Override
    public void destroyNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().delete(dropletId);
        Preconditions.checkState(this.nodeTerminatedPredicate.apply(dropletId), "node was not destroyed in the configured timeout");
    }

    @Override
    public void rebootNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().reboot(dropletId);
        Preconditions.checkState(this.nodeRunningPredicate.apply(dropletId), "node did not restart in the configured timeout");
    }

    @Override
    public void resumeNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().powerOn(dropletId);
        Preconditions.checkState(this.nodeRunningPredicate.apply(dropletId), "node did not started in the configured timeout");
    }

    @Override
    public void suspendNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().powerOff(dropletId);
        Preconditions.checkState(this.nodeStoppedPredicate.apply(dropletId), "node did not stop in the configured timeout");
    }
}

