/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.logging.Logger;

@Singleton
public class PresentInstances
implements Function<Set<RegionAndName>, Set<RunningInstance>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final EC2Api client;

    @Inject
    public PresentInstances(EC2Api client) {
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    public Set<RunningInstance> apply(Set<RegionAndName> regionAndIds) {
        if (Preconditions.checkNotNull(regionAndIds, "regionAndIds").isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ListMultimap<String, String> regionToInstanceIds = Multimaps.transformValues(Multimaps.index(regionAndIds, RegionAndName.regionFunction()), RegionAndName.nameFunction());
        for (Map.Entry entry : regionToInstanceIds.asMap().entrySet()) {
            String region = (String)entry.getKey();
            Collection instanceIds = entry.getValue();
            this.logger.trace("looking for instances %s in region %s", instanceIds, region);
            builder.addAll(Iterables.concat(this.client.getInstanceApi().get().describeInstancesInRegion(region, Iterables.toArray(instanceIds, String.class))));
        }
        return builder.build();
    }

    public String toString() {
        return "presentInstances()";
    }
}

