/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;

public class BundleTask
implements Comparable<BundleTask> {
    private final String region;
    private final String bundleId;
    private final Error error;
    private final String instanceId;
    private final int progress;
    private final Date startTime;
    private final String state;
    private final String bucket;
    private final String prefix;
    private final Date updateTime;

    @Override
    public int compareTo(BundleTask o) {
        return this == o ? 0 : this.getBundleId().compareTo(o.getBundleId());
    }

    public BundleTask(String region, String bundleId, @Nullable Error error, String instanceId, int progress, Date startTime, String state, String bucket, String prefix, Date updateTime) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.bundleId = Preconditions.checkNotNull(bundleId, "bundleId");
        this.error = error;
        this.instanceId = Preconditions.checkNotNull(instanceId, "instanceId");
        this.progress = progress;
        this.startTime = Preconditions.checkNotNull(startTime, "startTime");
        this.state = Preconditions.checkNotNull(state, "state");
        this.bucket = Preconditions.checkNotNull(bucket, "bucket");
        this.prefix = Preconditions.checkNotNull(prefix, "prefix");
        this.updateTime = Preconditions.checkNotNull(updateTime, "updateTime");
    }

    public String toString() {
        return "[bucket=" + this.bucket + ", bundleId=" + this.bundleId + ", error=" + this.error + ", instanceId=" + this.instanceId + ", prefix=" + this.prefix + ", progress=" + this.progress + ", region=" + this.region + ", startTime=" + this.startTime + ", state=" + this.state + ", updateTime=" + this.updateTime + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucket == null ? 0 : this.bucket.hashCode());
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + this.progress;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.updateTime == null ? 0 : this.updateTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleTask other = (BundleTask)obj;
        if (this.bucket == null ? other.bucket != null : !this.bucket.equals(other.bucket)) {
            return false;
        }
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.progress != other.progress) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.updateTime == null ? other.updateTime != null : !this.updateTime.equals(other.updateTime));
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public Error getError() {
        return this.error;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getProgress() {
        return this.progress;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getState() {
        return this.state;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public static class Error {
        private final String code;
        private final String message;

        public Error(String code, String message) {
            this.code = Preconditions.checkNotNull(code, "code");
            this.message = Preconditions.checkNotNull(message, "message");
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "[code=" + this.code + ", message=" + this.message + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Error other = (Error)obj;
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }
    }
}

