/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.location;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;

@Singleton
public class GoGridDefaultLocationSupplier
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locations;
    private final String defaultDC;

    @Inject
    GoGridDefaultLocationSupplier(@Memoized Supplier<Set<? extends Location>> locations, @Named(value="jclouds.template") String template) {
        this.locations = locations;
        Map<String, String> map = Splitter.on(',').trimResults().withKeyValueSeparator("=").split(template);
        this.defaultDC = Preconditions.checkNotNull(map.get("locationId"), "locationId not in % value: %s", (Object)"jclouds.template", (Object)template);
    }

    @Override
    public Location get() {
        return Iterables.find((Iterable)this.locations.get(), new Predicate<Location>(){

            @Override
            public boolean apply(Location input) {
                return input.getId().equals(GoGridDefaultLocationSupplier.this.defaultDC);
            }
        });
    }
}

