/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog;

import java.net.URI;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;

final class AutoValue_ServiceEndpoint
extends ServiceEndpoint {
    private final String id;
    private final String regionId;
    private final URI url;
    private final ServiceEndpoint.Interface iface;
    private final String type;
    private final String version;

    private AutoValue_ServiceEndpoint(@Nullable String id, @Nullable String regionId, URI url, ServiceEndpoint.Interface iface, String type, @Nullable String version) {
        this.id = id;
        this.regionId = regionId;
        this.url = url;
        this.iface = iface;
        this.type = type;
        this.version = version;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String regionId() {
        return this.regionId;
    }

    @Override
    public URI url() {
        return this.url;
    }

    @Override
    public ServiceEndpoint.Interface iface() {
        return this.iface;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public String version() {
        return this.version;
    }

    public String toString() {
        return "ServiceEndpoint{id=" + this.id + ", regionId=" + this.regionId + ", url=" + this.url + ", iface=" + (Object)((Object)this.iface) + ", type=" + this.type + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServiceEndpoint) {
            ServiceEndpoint that = (ServiceEndpoint)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.regionId == null ? that.regionId() == null : this.regionId.equals(that.regionId())) && this.url.equals(that.url()) && this.iface.equals((Object)that.iface()) && this.type.equals(that.type()) && (this.version == null ? that.version() == null : this.version.equals(that.version()));
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.id == null ? 0 : this.id.hashCode();
        h2 *= 1000003;
        h2 ^= this.regionId == null ? 0 : this.regionId.hashCode();
        h2 *= 1000003;
        h2 ^= this.url.hashCode();
        h2 *= 1000003;
        h2 ^= this.iface.hashCode();
        h2 *= 1000003;
        h2 ^= this.type.hashCode();
        h2 *= 1000003;
        return h2 ^= this.version == null ? 0 : this.version.hashCode();
    }

    static final class Builder
    extends ServiceEndpoint.Builder {
        private String id;
        private String regionId;
        private URI url;
        private ServiceEndpoint.Interface iface;
        private String type;
        private String version;

        Builder() {
        }

        @Override
        public ServiceEndpoint.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public ServiceEndpoint.Builder regionId(@Nullable String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        public ServiceEndpoint.Builder url(URI url) {
            if (url == null) {
                throw new NullPointerException("Null url");
            }
            this.url = url;
            return this;
        }

        @Override
        public ServiceEndpoint.Builder iface(ServiceEndpoint.Interface iface) {
            if (iface == null) {
                throw new NullPointerException("Null iface");
            }
            this.iface = iface;
            return this;
        }

        @Override
        public ServiceEndpoint.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public ServiceEndpoint.Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @Override
        public ServiceEndpoint build() {
            String missing = "";
            if (this.url == null) {
                missing = missing + " url";
            }
            if (this.iface == null) {
                missing = missing + " iface";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ServiceEndpoint(this.id, this.regionId, this.url, this.iface, this.type, this.version);
        }
    }
}

