/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class ExternalGatewayInfo {
    @Named(value="network_id")
    protected final String networkId;
    @Named(value="enable_snat")
    protected final Boolean enableSnat;

    @ConstructorProperties(value={"network_id", "enable_snat"})
    protected ExternalGatewayInfo(String networkId, Boolean enableSnat) {
        this.networkId = networkId;
        this.enableSnat = enableSnat;
    }

    @Nullable
    public String getNetworkId() {
        return this.networkId;
    }

    @Nullable
    public Boolean getEnableSnat() {
        return this.enableSnat;
    }

    public int hashCode() {
        return Objects.hashCode(this.networkId, this.enableSnat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalGatewayInfo that = (ExternalGatewayInfo)o;
        return Objects.equal(this.networkId, that.networkId) && Objects.equal(this.enableSnat, that.enableSnat);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromExternalGatewayInfo(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("networkId", this.networkId).add("enableSnat", this.enableSnat).toString();
    }

    public static class Builder {
        protected String networkId;
        protected Boolean enableSnat;

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder enableSnat(Boolean enableSnat) {
            this.enableSnat = enableSnat;
            return this;
        }

        public ExternalGatewayInfo build() {
            return new ExternalGatewayInfo(this.networkId, this.enableSnat);
        }

        public Builder fromExternalGatewayInfo(ExternalGatewayInfo in) {
            return this.networkId(in.getNetworkId()).enableSnat(in.getEnableSnat());
        }
    }
}

