/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain.lbaas.v1;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.HealthMonitorStatus;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.LBaaSStatus;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.Protocol;

public class Pool {
    public static String ROUND_ROBIN = "ROUND_ROBIN";
    public static String LEAST_CONNECTIONS = "LEAST_CONNECTIONS";
    public static String SOURCE_IP = "SOURCE_IP";
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="subnet_id")
    private String subnetId;
    private Protocol protocol;
    @Named(value="lb_method")
    private String lbMethod;
    private String provider;
    private String name;
    private String description;
    @Named(value="health_monitors")
    private ImmutableSet<String> healthMonitors;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    private String id;
    @Named(value="vip_id")
    private String vipId;
    private ImmutableSet<String> members;
    @Named(value="health_monitors_status")
    private ImmutableList<HealthMonitorStatus> healthMonitorsStatus;
    private LBaaSStatus status;
    @Named(value="status_description")
    private String statusDescription;

    @ConstructorProperties(value={"id", "tenant_id", "vip_id", "name", "description", "subnet_id", "protocol", "provider", "lb_method", "health_monitors", "health_monitors_status", "members", "admin_state_up", "status", "status_description"})
    private Pool(String id, String tenantId, String vipId, String name, String description, String subnetId, Protocol protocol, String provider, String lbMethod, ImmutableSet<String> healthMonitors, ImmutableList<HealthMonitorStatus> healthMonitorsStatus, ImmutableSet<String> members, Boolean adminStateUp, LBaaSStatus status, String statusDescription) {
        this.id = id;
        this.tenantId = tenantId;
        this.vipId = vipId;
        this.name = name;
        this.description = description;
        this.subnetId = subnetId;
        this.protocol = protocol;
        this.provider = provider;
        this.lbMethod = lbMethod;
        this.healthMonitors = healthMonitors;
        this.healthMonitorsStatus = healthMonitorsStatus;
        this.members = members;
        this.adminStateUp = adminStateUp;
        this.status = status;
        this.statusDescription = statusDescription;
    }

    private Pool() {
    }

    private Pool(Pool pool) {
        this(pool.id, pool.tenantId, pool.vipId, pool.name, pool.description, pool.subnetId, pool.protocol, pool.provider, pool.lbMethod, pool.healthMonitors, pool.healthMonitorsStatus, pool.members, pool.adminStateUp, pool.status, pool.statusDescription);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getVIPId() {
        return this.vipId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getSubnetId() {
        return this.subnetId;
    }

    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Nullable
    public String getProvider() {
        return this.provider;
    }

    @Nullable
    public String getLBMethod() {
        return this.lbMethod;
    }

    @Nullable
    public ImmutableSet<String> getHealthMonitors() {
        return this.healthMonitors;
    }

    @Nullable
    public ImmutableList<HealthMonitorStatus> getHealthMonitorsStatus() {
        return this.healthMonitorsStatus;
    }

    @Nullable
    public ImmutableSet<String> getMembers() {
        return this.members;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public LBaaSStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getStatusDescription() {
        return this.statusDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool that = (Pool)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.vipId, that.vipId) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.subnetId, that.subnetId) && Objects.equal((Object)this.protocol, (Object)that.protocol) && Objects.equal(this.provider, that.provider) && Objects.equal(this.lbMethod, that.lbMethod) && Objects.equal(this.healthMonitors, that.healthMonitors) && Objects.equal(this.healthMonitorsStatus, that.healthMonitorsStatus) && Objects.equal(this.members, that.members) && Objects.equal(this.adminStateUp, that.adminStateUp) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.statusDescription, that.statusDescription);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.tenantId, this.vipId, this.name, this.description, this.subnetId, this.protocol, this.provider, this.lbMethod, this.healthMonitors, this.healthMonitorsStatus, this.members, this.adminStateUp, this.status, this.statusDescription});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("vipId", this.vipId).add("name", this.name).add("description", this.description).add("subnetId", this.subnetId).add("protocol", (Object)this.protocol).add("provider", this.provider).add("lbMethod", this.lbMethod).add("healthMonitors", this.healthMonitors).add("healthMonitorsStatus", this.healthMonitorsStatus).add("members", this.members).add("adminStateUp", this.adminStateUp).add("status", (Object)this.status).add("statusDescription", this.statusDescription).toString();
    }

    public static CreateBuilder createBuilder(String subnetId, Protocol protocol, String lbMethod) {
        return new CreateBuilder(subnetId, protocol, lbMethod);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class UpdatePool
    extends Pool {
        private UpdatePool(Pool pool) {
            super(pool);
        }
    }

    public static class CreatePool
    extends Pool {
        private CreatePool(Pool pool) {
            super(pool);
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdatePool build() {
            return new UpdatePool(this.pool);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String subnetId, Protocol protocol, String lbMethod) {
            this.subnetId(subnetId).protocol(protocol).lbMethod(lbMethod);
        }

        public CreateBuilder tenantId(String tenantId) {
            this.pool.tenantId = tenantId;
            return this.self();
        }

        public CreateBuilder subnetId(String subnetId) {
            this.pool.subnetId = subnetId;
            return this.self();
        }

        public CreateBuilder protocol(Protocol protocol) {
            this.pool.protocol = protocol;
            return this.self();
        }

        public CreateBuilder provider(String provider) {
            this.pool.provider = provider;
            return this.self();
        }

        public CreatePool build() {
            return new CreatePool(this.pool);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected Pool pool = new Pool();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType name(String name) {
            this.pool.name = name;
            return this.self();
        }

        public ParameterizedBuilderType description(String description) {
            this.pool.description = description;
            return this.self();
        }

        public ParameterizedBuilderType lbMethod(String lbMethod) {
            this.pool.lbMethod = lbMethod;
            return this.self();
        }

        public ParameterizedBuilderType healthMonitors(ImmutableSet<String> healthMonitors) {
            this.pool.healthMonitors = healthMonitors;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.pool.adminStateUp = adminStateUp;
            return this.self();
        }
    }
}

