/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;

@Singleton
public class NovaImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final NovaApi novaApi;
    private final ListeningExecutorService userExecutor;
    private final Supplier<Set<? extends Location>> locations;
    private final Predicate<AtomicReference<Image>> imageAvailablePredicate;

    @Inject
    public NovaImageExtension(NovaApi novaApi, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Memoized Supplier<Set<? extends Location>> locations, @Named(value="jclouds.compute.timeout.image-available") Predicate<AtomicReference<Image>> imageAvailablePredicate) {
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.imageAvailablePredicate = Preconditions.checkNotNull(imageAvailablePredicate, "imageAvailablePredicate");
    }

    @Override
    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        Server server = this.novaApi.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
        if (server == null) {
            throw new NoSuchElementException("Cannot find server with id: " + regionAndId);
        }
        CloneImageTemplate template = new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
        return template;
    }

    @Override
    public ListenableFuture<Image> createImage(ImageTemplate template) {
        Preconditions.checkState(template instanceof CloneImageTemplate, " openstack-nova only supports creating images through cloning.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        RegionAndId sourceImageRegionAndId = RegionAndId.fromSlashEncoded(cloneTemplate.getSourceNodeId());
        String newImageId = this.novaApi.getServerApi(sourceImageRegionAndId.getRegion()).createImageFromServer(cloneTemplate.getName(), sourceImageRegionAndId.getId());
        RegionAndId targetImageRegionAndId = RegionAndId.fromRegionAndId(sourceImageRegionAndId.getRegion(), newImageId);
        this.logger.info(">> Registered new Image %s, waiting for it to become available.", newImageId);
        final AtomicReference<Image> image = Atomics.newReference(new ImageBuilder().location(Iterables.find((Iterable)this.locations.get(), LocationPredicates.idEquals(targetImageRegionAndId.getRegion()))).id(targetImageRegionAndId.slashEncode()).providerId(targetImageRegionAndId.getId()).description(cloneTemplate.getName()).operatingSystem(OperatingSystem.builder().description(cloneTemplate.getName()).build()).status(Image.Status.PENDING).build());
        return this.userExecutor.submit(new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                if (NovaImageExtension.this.imageAvailablePredicate.apply(image)) {
                    return (Image)image.get();
                }
                throw new UncheckedTimeoutException("Image was not created within the time limit: " + image.get());
            }
        });
    }

    @Override
    public boolean deleteImage(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        try {
            this.novaApi.getImageApi(regionAndId.getRegion()).delete(regionAndId.getId());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

