/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.binder.nic.CreateNicRequestBinder;
import org.jclouds.profitbricks.binder.nic.SetInternetAccessBinder;
import org.jclouds.profitbricks.binder.nic.UpdateNicRequestBinder;
import org.jclouds.profitbricks.domain.Nic;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.RequestIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.nic.NicIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.nic.NicListResponseHandler;
import org.jclouds.profitbricks.http.parser.nic.NicResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface NicApi {
    @POST
    @Named(value="nics:getall")
    @Payload(value="<ws:getAllNic/>")
    @XMLResponseParser(value=NicListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Nic> getAllNics();

    @POST
    @Named(value="nic:create")
    @MapBinder(value=CreateNicRequestBinder.class)
    @XMLResponseParser(value=NicIdOnlyResponseHandler.class)
    public String createNic(@PayloadParam(value="nic") Nic.Request.CreatePayload var1);

    @POST
    @Named(value="nic:get")
    @Payload(value="<ws:getNic><nicId>{id}</nicId></ws:getNic>")
    @XMLResponseParser(value=NicResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Nic getNic(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="nic:update")
    @MapBinder(value=UpdateNicRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String updateNic(@PayloadParam(value="nic") Nic.Request.UpdatePayload var1);

    @POST
    @Named(value="nic:setInternetAccess")
    @MapBinder(value=SetInternetAccessBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String setInternetAccess(@PayloadParam(value="nic") Nic.Request.SetInternetAccessPayload var1);

    @POST
    @Named(value="nic:delete")
    @Payload(value="<ws:deleteNic><nicId>{id}</nicId></ws:deleteNic>")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteNic(@PayloadParam(value="id") String var1);
}

