/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ssh;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class AuthorizeRSAPublicKeys
implements Statement {
    private final String sshDir;
    private final List<String> publicKeys;
    private final String owner;

    public AuthorizeRSAPublicKeys(Iterable<String> publicKeys) {
        this("~/.ssh", publicKeys, null);
    }

    public AuthorizeRSAPublicKeys(Iterable<String> publicKeys, @Nullable String owner) {
        this("~/.ssh", publicKeys, owner);
    }

    public AuthorizeRSAPublicKeys(String sshDir, Iterable<String> publicKeys, @Nullable String owner) {
        this.sshDir = Preconditions.checkNotNull(sshDir, "sshDir");
        this.publicKeys = ImmutableList.copyOf(Preconditions.checkNotNull(publicKeys, "publicKeys"));
        this.owner = owner;
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    @Override
    public String render(OsFamily family) {
        Preconditions.checkNotNull(family, "family");
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add(Statements.exec("mkdir -p " + this.sshDir));
        String authorizedKeys = this.sshDir + "{fs}authorized_keys";
        statements.add(Statements.appendFile(authorizedKeys, Splitter.on('\n').split(Joiner.on("\n\n").join(this.publicKeys))));
        statements.add(Statements.exec("chmod 600 " + authorizedKeys));
        if (this.owner != null) {
            statements.add(Statements.exec(String.format("chown -R %s %s", this.owner, this.sshDir)));
        }
        return new StatementList(statements.build()).render(family);
    }
}

