/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.aws.ec2.compute.config.ImageQuery;
import org.jclouds.aws.ec2.compute.suppliers.CallForImages;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

public final class AWSEC2ImageSupplier
implements Supplier<Set<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final Set<String> clusterComputeIds;
    private final CallForImages.Factory factory;
    private final ListeningExecutorService userExecutor;
    private final Supplier<Set<String>> regions;
    private final Map<String, String> queries;
    private final Iterable<String> clusterRegions;
    private final Supplier<LoadingCache<RegionAndName, ? extends Image>> cache;

    @Inject
    AWSEC2ImageSupplier(@Region Supplier<Set<String>> regions, @ImageQuery Map<String, String> queries, @Named(value="jclouds.ec2.cc-regions") String clusterRegions, Supplier<LoadingCache<RegionAndName, ? extends Image>> cache, CallForImages.Factory factory, @ClusterCompute Set<String> clusterComputeIds, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.factory = factory;
        this.regions = regions;
        this.queries = queries;
        this.clusterRegions = Splitter.on(',').split(clusterRegions);
        this.cache = cache;
        this.clusterComputeIds = clusterComputeIds;
        this.userExecutor = userExecutor;
    }

    @Override
    public Set<? extends Image> get() {
        ImmutableSet parsedImages;
        ImmutableSet clusterImages;
        String amiQuery = this.queries.get("jclouds.ec2.ami-query");
        String ccAmiQuery = this.queries.get("jclouds.ec2.cc-ami-query");
        Set<String> regionIds = this.regions.get();
        ListenableFuture<Iterable<Image>> normalImages = this.images(regionIds, amiQuery, "jclouds.ec2.ami-query");
        try {
            clusterImages = ImmutableSet.copyOf((Iterable)this.images(Iterables.filter(this.clusterRegions, Predicates.in(regionIds)), ccAmiQuery, "jclouds.ec2.cc-ami-query").get());
        }
        catch (Exception e) {
            this.logger.warn(e, "Error parsing images in query %s", ccAmiQuery);
            throw Throwables.propagate(e);
        }
        Iterables.addAll(this.clusterComputeIds, Iterables.transform(clusterImages, new Function<Image, String>(){

            @Override
            public String apply(Image arg0) {
                return arg0.getId();
            }
        }));
        try {
            parsedImages = ImmutableSet.copyOf(Iterables.concat(clusterImages, (Iterable)normalImages.get()));
        }
        catch (Exception e) {
            this.logger.warn(e, "Error parsing images in query %s", amiQuery);
            throw Throwables.propagate(e);
        }
        Map<RegionAndName, ? extends Image> imageMap = ImagesToRegionAndIdMap.imagesToMap(parsedImages);
        this.cache.get().invalidateAll();
        this.cache.get().putAll((Map)Map.class.cast(imageMap));
        this.logger.debug("<< images(%d)", imageMap.size());
        return new ForwardingSet<Image>(){

            @Override
            protected Set<Image> delegate() {
                return ImmutableSet.copyOf(((LoadingCache)AWSEC2ImageSupplier.this.cache.get()).asMap().values());
            }
        };
    }

    private ListenableFuture<Iterable<Image>> images(Iterable<String> regions, String query, String tag) {
        if (query == null) {
            this.logger.debug(">> no %s specified, skipping image parsing", tag);
            return Futures.immediateFuture(ImmutableSet.of());
        }
        return this.userExecutor.submit((Callable)this.factory.parseImagesFromRegionsUsingFilter(regions, QueryStringToMultimap.INSTANCE.apply(query)));
    }

    public static enum QueryStringToMultimap implements Function<String, Multimap<String, String>>
    {
        INSTANCE;


        @Override
        public Multimap<String, String> apply(String arg0) {
            ImmutableMultimap.Builder<String, Object> builder = ImmutableMultimap.builder();
            for (String pair : Splitter.on(';').split(arg0)) {
                String[] keyValue = pair.split("=");
                if (keyValue.length == 1) {
                    builder.putAll(keyValue[0], ImmutableSet.of());
                    continue;
                }
                builder.putAll(keyValue[0], Splitter.on(',').split(keyValue[1]));
            }
            return builder.build();
        }
    }
}

