/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.AbstractCollection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.extensions.internal.DelegatingImageExtension;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.suppliers.ImageCacheSupplier;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Maps2;

@Singleton
public class BaseComputeService
implements ComputeService {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final ComputeServiceContext context;
    protected final Map<String, Credentials> credentialStore;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Set<? extends Hardware>> hardwareProfiles;
    private final Supplier<Set<? extends Location>> locations;
    private final GetImageStrategy getImageStrategy;
    private final ListNodesStrategy listNodesStrategy;
    private final GetNodeMetadataStrategy getNodeMetadataStrategy;
    private final CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy;
    private final RebootNodeStrategy rebootNodeStrategy;
    private final DestroyNodeStrategy destroyNodeStrategy;
    private final ResumeNodeStrategy resumeNodeStrategy;
    private final SuspendNodeStrategy suspendNodeStrategy;
    private final Provider<TemplateBuilder> templateBuilderProvider;
    private final Provider<TemplateOptions> templateOptionsProvider;
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    private final Predicate<AtomicReference<NodeMetadata>> nodeTerminated;
    private final Predicate<AtomicReference<NodeMetadata>> nodeSuspended;
    private final InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory;
    private final InitAdminAccess initAdminAccess;
    private final PersistNodeCredentials persistNodeCredentials;
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;
    private final ListeningExecutorService userExecutor;
    private final Optional<ImageExtension> imageExtension;
    private final Optional<SecurityGroupExtension> securityGroupExtension;

    @Inject
    protected BaseComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwareProfiles, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy resumeNodeStrategy, SuspendNodeStrategy suspendNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, InitAdminAccess initAdminAccess, RunScriptOnNode.Factory runScriptOnNodeFactory, PersistNodeCredentials persistNodeCredentials, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Optional<ImageExtension> imageExtension, Optional<SecurityGroupExtension> securityGroupExtension, DelegatingImageExtension.Factory delegatingImageExtension) {
        this.context = Preconditions.checkNotNull(context, "context");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
        this.images = Preconditions.checkNotNull(images, "images");
        this.hardwareProfiles = Preconditions.checkNotNull(hardwareProfiles, "hardwareProfiles");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.getNodeMetadataStrategy = Preconditions.checkNotNull(getNodeMetadataStrategy, "getNodeMetadataStrategy");
        this.listNodesStrategy = Preconditions.checkNotNull(listNodesStrategy, "listNodesStrategy");
        this.getImageStrategy = Preconditions.checkNotNull(getImageStrategy, "getImageStrategy");
        this.runNodesAndAddToSetStrategy = Preconditions.checkNotNull(runNodesAndAddToSetStrategy, "runNodesAndAddToSetStrategy");
        this.rebootNodeStrategy = Preconditions.checkNotNull(rebootNodeStrategy, "rebootNodeStrategy");
        this.resumeNodeStrategy = Preconditions.checkNotNull(resumeNodeStrategy, "resumeNodeStrategy");
        this.suspendNodeStrategy = Preconditions.checkNotNull(suspendNodeStrategy, "suspendNodeStrategy");
        this.destroyNodeStrategy = Preconditions.checkNotNull(destroyNodeStrategy, "destroyNodeStrategy");
        this.templateBuilderProvider = Preconditions.checkNotNull(templateBuilderProvider, "templateBuilderProvider");
        this.templateOptionsProvider = Preconditions.checkNotNull(templateOptionsProvider, "templateOptionsProvider");
        this.nodeRunning = Preconditions.checkNotNull(nodeRunning, "nodeRunning");
        this.nodeTerminated = Preconditions.checkNotNull(nodeTerminated, "nodeTerminated");
        this.nodeSuspended = Preconditions.checkNotNull(nodeSuspended, "nodeSuspended");
        this.initScriptRunnerFactory = Preconditions.checkNotNull(initScriptRunnerFactory, "initScriptRunnerFactory");
        this.initAdminAccess = Preconditions.checkNotNull(initAdminAccess, "initAdminAccess");
        this.runScriptOnNodeFactory = Preconditions.checkNotNull(runScriptOnNodeFactory, "runScriptOnNodeFactory");
        this.persistNodeCredentials = Preconditions.checkNotNull(persistNodeCredentials, "persistNodeCredentials");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.securityGroupExtension = Preconditions.checkNotNull(securityGroupExtension, "securityGroupExtension");
        this.imageExtension = imageExtension.isPresent() && images instanceof ImageCacheSupplier ? Optional.of(delegatingImageExtension.create((ImageCacheSupplier)ImageCacheSupplier.class.cast(images), imageExtension.get())) : Preconditions.checkNotNull(imageExtension, "imageExtension");
    }

    @Override
    public ComputeServiceContext getContext() {
        return this.context;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Map<?, Exception> executionExceptions;
        Preconditions.checkNotNull(group, "group cannot be null");
        Preconditions.checkNotNull(template.getLocation(), "location");
        this.logger.debug(">> running %d node%s group(%s) location(%s) image(%s) hardwareProfile(%s) options(%s)", count, count > 1 ? "s" : "", group, template.getLocation().getId(), template.getImage().getId(), template.getHardware().getId(), template.getOptions());
        AbstractCollection goodNodes = Sets.newLinkedHashSet();
        Map<NodeMetadata, Exception> badNodes = Maps.newLinkedHashMap();
        LinkedHashMultimap<NodeMetadata, CustomizationResponse> customizationResponses = LinkedHashMultimap.create();
        if (template.getOptions().getRunScript() != null) {
            this.initAdminAccess.visit(template.getOptions().getRunScript());
        }
        Map<?, ListenableFuture<Void>> responses = this.runNodesAndAddToSetStrategy.execute(group, count, template, (Set<NodeMetadata>)((Object)goodNodes), badNodes, (Multimap<NodeMetadata, CustomizationResponse>)customizationResponses);
        try {
            executionExceptions = FutureIterables.awaitCompletion(responses, this.userExecutor, null, this.logger, "createNodesInGroup(" + group + ")");
        }
        catch (TimeoutException te) {
            throw Throwables.propagate(te);
        }
        Function<NodeMetadata, NodeMetadata> fn = this.persistNodeCredentials.always(template.getOptions().getRunScript());
        badNodes = Maps2.transformKeys(badNodes, fn);
        goodNodes = ImmutableSet.copyOf(Iterables.transform(goodNodes, fn));
        if (!executionExceptions.isEmpty() || !badNodes.isEmpty()) {
            throw new RunNodesException(group, count, template, (Set<? extends NodeMetadata>)((Object)goodNodes), executionExceptions, (Map<? extends NodeMetadata, ? extends Throwable>)badNodes);
        }
        return goodNodes;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, TemplateOptions templateOptions) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateBuilder().any().options(templateOptions).build());
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateOptions());
    }

    @Override
    public void destroyNode(String id) {
        NodeMetadata destroyedNodeOrNull = this.doDestroyNode(id);
        if (destroyedNodeOrNull != null) {
            this.cleanUpIncidentalResourcesOfDeadNodes(ImmutableSet.of(destroyedNodeOrNull));
        }
    }

    @Override
    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<? super NodeMetadata> filter) {
        this.logger.debug(">> destroying nodes matching(%s)", filter);
        ImmutableSet<? extends NodeMetadata> destroyNodes = ImmutableSet.copyOf(FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminated(filter), new Function<NodeMetadata, ListenableFuture<? extends NodeMetadata>>(){

            @Override
            public ListenableFuture<NodeMetadata> apply(final NodeMetadata from) {
                return BaseComputeService.this.userExecutor.submit(new Callable<NodeMetadata>(){

                    @Override
                    public NodeMetadata call() throws Exception {
                        BaseComputeService.this.doDestroyNode(from.getId());
                        return from;
                    }

                    public String toString() {
                        return "destroyNode(" + from.getId() + ")";
                    }
                });
            }
        }, this.userExecutor, null, this.logger, "destroyNodesMatching(" + filter + ")"));
        this.logger.debug("<< destroyed(%d)", destroyNodes.size());
        this.cleanUpIncidentalResourcesOfDeadNodes(destroyNodes);
        return destroyNodes;
    }

    @Nullable
    protected NodeMetadata doDestroyNode(String id) {
        boolean successful;
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> destroying node(%s)", id);
        NodeMetadata nodeMetadata = this.destroyNodeStrategy.destroyNode(id);
        if (nodeMetadata == null) {
            return null;
        }
        AtomicReference<NodeMetadata> node = Atomics.newReference(nodeMetadata);
        boolean bl = successful = node.get() == null || this.nodeTerminated.apply(node);
        if (successful) {
            this.credentialStore.remove("node#" + id);
        }
        this.logger.debug("<< destroyed node(%s) success(%s)", id, successful);
        return nodeMetadata;
    }

    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminated(Predicate<? super NodeMetadata> filter) {
        return Iterables.filter(this.detailsOnAllNodes(), Predicates.and(Preconditions.checkNotNull(filter, "filter"), Predicates.not(NodePredicates.TERMINATED)));
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(Predicate<? super NodeMetadata> filter) {
        Iterable<? extends NodeMetadata> nodes = this.nodesMatchingFilterAndNotTerminated(filter);
        if (Iterables.isEmpty(nodes)) {
            throw new NoSuchElementException("no nodes matched filter: " + filter);
        }
        return nodes;
    }

    @Override
    public Set<? extends ComputeMetadata> listNodes() {
        this.logger.trace(">> listing nodes", new Object[0]);
        LinkedHashSet<? extends ComputeMetadata> set = Sets.newLinkedHashSet(this.listNodesStrategy.listNodes());
        this.logger.trace("<< list(%d)", set.size());
        return set;
    }

    public Set<? extends NodeMetadata> listNodesByIds(Iterable<String> ids) {
        Preconditions.checkNotNull(ids, "ids");
        this.logger.trace(">> listing node with ids(%s)", ids);
        ImmutableSet<? extends NodeMetadata> set = ImmutableSet.copyOf(this.listNodesStrategy.listNodesByIds(ids));
        this.logger.trace("<< list(%d)", set.size());
        return set;
    }

    @Override
    public Set<? extends NodeMetadata> listNodesDetailsMatching(Predicate<? super NodeMetadata> filter) {
        Preconditions.checkNotNull(filter, "filter");
        this.logger.trace(">> listing node details matching(%s)", filter);
        LinkedHashSet<? extends NodeMetadata> set = Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(filter));
        this.logger.trace("<< list(%d)", set.size());
        return set;
    }

    @Override
    public Set<? extends Hardware> listHardwareProfiles() {
        return this.hardwareProfiles.get();
    }

    @Override
    public Set<? extends Image> listImages() {
        return this.images.get();
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return this.locations.get();
    }

    @Override
    public TemplateBuilder templateBuilder() {
        return this.templateBuilderProvider.get();
    }

    @Override
    public NodeMetadata getNodeMetadata(String id) {
        Preconditions.checkNotNull(id, "id");
        return this.getNodeMetadataStrategy.getNode(id);
    }

    @Override
    public Image getImage(String id) {
        Preconditions.checkNotNull(id, "id");
        return this.getImageStrategy.getImage(id);
    }

    @Override
    public void rebootNode(String id) {
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> rebooting node(%s)", id);
        AtomicReference<NodeMetadata> node = Atomics.newReference(this.rebootNodeStrategy.rebootNode(id));
        boolean successful = this.nodeRunning.apply(node);
        this.logger.debug("<< rebooted node(%s) success(%s)", id, successful);
    }

    @Override
    public Set<? extends NodeMetadata> rebootNodesMatching(Predicate<? super NodeMetadata> filter) {
        this.logger.debug(">> rebooting nodes matching(%s)", filter);
        ImmutableSet<? extends NodeMetadata> rebootNodes = ImmutableSet.copyOf(FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminated(filter), new Function<NodeMetadata, ListenableFuture<? extends NodeMetadata>>(){

            @Override
            public ListenableFuture<NodeMetadata> apply(final NodeMetadata from) {
                return BaseComputeService.this.userExecutor.submit(new Callable<NodeMetadata>(){

                    @Override
                    public NodeMetadata call() throws Exception {
                        BaseComputeService.this.rebootNode(from.getId());
                        return from;
                    }

                    public String toString() {
                        return "rebootNode(" + from.getId() + ")";
                    }
                });
            }
        }, this.userExecutor, null, this.logger, "rebootNodesMatching(" + filter + ")"));
        this.logger.debug("<< rebooted(%d)", rebootNodes.size());
        return rebootNodes;
    }

    @Override
    public void resumeNode(String id) {
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> resuming node(%s)", id);
        AtomicReference<NodeMetadata> node = Atomics.newReference(this.resumeNodeStrategy.resumeNode(id));
        boolean successful = this.nodeRunning.apply(node);
        this.logger.debug("<< resumed node(%s) success(%s)", id, successful);
    }

    @Override
    public Set<? extends NodeMetadata> resumeNodesMatching(Predicate<? super NodeMetadata> filter) {
        this.logger.debug(">> resuming nodes matching(%s)", filter);
        ImmutableSet<? extends NodeMetadata> resumeNodes = ImmutableSet.copyOf(FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminated(filter), new Function<NodeMetadata, ListenableFuture<? extends NodeMetadata>>(){

            @Override
            public ListenableFuture<NodeMetadata> apply(final NodeMetadata from) {
                return BaseComputeService.this.userExecutor.submit(new Callable<NodeMetadata>(){

                    @Override
                    public NodeMetadata call() throws Exception {
                        BaseComputeService.this.resumeNode(from.getId());
                        return from;
                    }

                    public String toString() {
                        return "resumeNode(" + from.getId() + ")";
                    }
                });
            }
        }, this.userExecutor, null, this.logger, "resumeNodesMatching(" + filter + ")"));
        this.logger.debug("<< resumed(%d)", resumeNodes.size());
        return resumeNodes;
    }

    @Override
    public void suspendNode(String id) {
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> suspending node(%s)", id);
        AtomicReference<NodeMetadata> node = Atomics.newReference(this.suspendNodeStrategy.suspendNode(id));
        boolean successful = this.nodeSuspended.apply(node);
        this.logger.debug("<< suspended node(%s) success(%s)", id, successful);
    }

    @Override
    public Set<? extends NodeMetadata> suspendNodesMatching(Predicate<? super NodeMetadata> filter) {
        this.logger.debug(">> suspending nodes matching(%s)", filter);
        ImmutableSet<? extends NodeMetadata> suspendNodes = ImmutableSet.copyOf(FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminated(filter), new Function<NodeMetadata, ListenableFuture<? extends NodeMetadata>>(){

            @Override
            public ListenableFuture<NodeMetadata> apply(final NodeMetadata from) {
                return BaseComputeService.this.userExecutor.submit(new Callable<NodeMetadata>(){

                    @Override
                    public NodeMetadata call() throws Exception {
                        BaseComputeService.this.suspendNode(from.getId());
                        return from;
                    }

                    public String toString() {
                        return "suspendNode(" + from.getId() + ")";
                    }
                });
            }
        }, this.userExecutor, null, this.logger, "suspendNodesMatching(" + filter + ")"));
        this.logger.debug("<< suspended(%d)", suspendNodes.size());
        return suspendNodes;
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<? super NodeMetadata> filter, String runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.literal(Preconditions.checkNotNull(runScript, "runScript")));
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<? super NodeMetadata> filter, Statement runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, runScript, RunScriptOptions.NONE);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<? super NodeMetadata> filter, String runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.literal(Preconditions.checkNotNull(runScript, "runScript")), options);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<? super NodeMetadata> filter, Statement runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        Preconditions.checkNotNull(filter, "filter");
        Preconditions.checkNotNull(runScript, "runScript");
        Preconditions.checkNotNull(options, "options");
        LinkedHashMap<NodeMetadata, ExecResponse> goodNodes = Maps.newLinkedHashMap();
        Map<NodeMetadata, Exception> badNodes = Maps.newLinkedHashMap();
        LinkedHashMap<NodeMetadata, Future> responses = Maps.newLinkedHashMap();
        Map exceptions = ImmutableMap.of();
        this.initAdminAccess.visit(runScript);
        Iterable<RunScriptOnNode> scriptRunners = this.transformNodesIntoInitializedScriptRunners(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), runScript, options, badNodes);
        if (!Iterables.isEmpty(scriptRunners)) {
            for (RunScriptOnNode runner : scriptRunners) {
                responses.put(runner.getNode(), this.userExecutor.submit((Callable)new RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap(runner, goodNodes, badNodes)));
            }
            try {
                exceptions = FutureIterables.awaitCompletion(responses, this.userExecutor, null, this.logger, "runScriptOnNodesMatching(" + filter + ")");
            }
            catch (TimeoutException te) {
                throw Throwables.propagate(te);
            }
        }
        Function<NodeMetadata, NodeMetadata> fn = this.persistNodeCredentials.ifAdminAccess(runScript);
        badNodes = Maps2.transformKeys(badNodes, fn);
        goodNodes = Maps2.transformKeys(goodNodes, fn);
        if (!exceptions.isEmpty() || !badNodes.isEmpty()) {
            throw new RunScriptOnNodesException(runScript, options, goodNodes, exceptions, badNodes);
        }
        return goodNodes;
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript) {
        return this.runScriptOnNode(id, runScript, RunScriptOptions.NONE);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript, RunScriptOptions options) {
        return this.runScriptOnNode(id, Statements.literal(Preconditions.checkNotNull(runScript, "runScript")), options);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript) {
        return this.runScriptOnNode(id, runScript, RunScriptOptions.NONE);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript, RunScriptOptions options) {
        NodeMetadata node = this.getNodeMetadata(id);
        if (node == null) {
            throw new NoSuchElementException(id);
        }
        if (node.getStatus() != NodeMetadata.Status.RUNNING) {
            throw new IllegalStateException("node " + id + " needs to be running before executing a script on it. current state: " + ComputeServiceUtils.formatStatus(node));
        }
        this.initAdminAccess.visit(runScript);
        node = this.updateNodeWithCredentialsIfPresent(node, options);
        ExecResponse response = this.runScriptOnNodeFactory.create(node, runScript, options).init().call();
        this.persistNodeCredentials.ifAdminAccess(runScript).apply(node);
        return response;
    }

    @Override
    public ListenableFuture<ExecResponse> submitScriptOnNode(String id, String runScript, RunScriptOptions options) {
        return this.submitScriptOnNode(id, Statements.literal(Preconditions.checkNotNull(runScript, "runScript")), options);
    }

    @Override
    public ListenableFuture<ExecResponse> submitScriptOnNode(String id, final Statement runScript, RunScriptOptions options) {
        NodeMetadata node = this.getNodeMetadata(id);
        if (node == null) {
            throw new NoSuchElementException(id);
        }
        if (node.getStatus() != NodeMetadata.Status.RUNNING) {
            throw new IllegalStateException("node " + id + " needs to be running before executing a script on it. current state: " + ComputeServiceUtils.formatStatus(node));
        }
        this.initAdminAccess.visit(runScript);
        final NodeMetadata node1 = this.updateNodeWithCredentialsIfPresent(node, options);
        ListenableFuture<ExecResponse> response = this.runScriptOnNodeFactory.submit(node1, runScript, options);
        response.addListener(new Runnable(){

            @Override
            public void run() {
                BaseComputeService.this.persistNodeCredentials.ifAdminAccess(runScript).apply(node1);
            }
        }, this.userExecutor);
        return response;
    }

    private Iterable<RunScriptOnNode> transformNodesIntoInitializedScriptRunners(Iterable<? extends NodeMetadata> nodes, Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
        return Iterables.filter(FutureIterables.transformParallel(nodes, new TransformNodesIntoInitializedScriptRunners(script, options, badNodes), this.userExecutor, null, this.logger, "initialize script runners"), Predicates.notNull());
    }

    private Set<? extends NodeMetadata> detailsOnAllNodes() {
        return Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(NodePredicates.all()));
    }

    @Override
    public TemplateOptions templateOptions() {
        return this.templateOptionsProvider.get();
    }

    protected NodeMetadata updateNodeWithCredentialsIfPresent(NodeMetadata node, RunScriptOptions options) {
        Preconditions.checkNotNull(node, "node");
        LoginCredentials.Builder builder = LoginCredentials.builder(node.getCredentials());
        if (options.getLoginUser() != null) {
            builder.user(options.getLoginUser());
        }
        if (options.hasLoginPasswordOption()) {
            if (options.hasLoginPassword()) {
                builder.password(options.getLoginPassword());
            } else {
                builder.noPassword();
            }
        }
        if (options.hasLoginPrivateKeyOption()) {
            if (options.hasLoginPrivateKey()) {
                builder.privateKey(options.getLoginPrivateKey());
            } else {
                builder.noPrivateKey();
            }
        }
        if (options.shouldAuthenticateSudo() != null) {
            builder.authenticateSudo(true);
        }
        return NodeMetadataBuilder.fromNodeMetadata(node).credentials(builder.build()).build();
    }

    @Override
    public Optional<ImageExtension> getImageExtension() {
        return this.imageExtension;
    }

    @Override
    public Optional<SecurityGroupExtension> getSecurityGroupExtension() {
        return this.securityGroupExtension;
    }

    private final class TransformNodesIntoInitializedScriptRunners
    implements Function<NodeMetadata, ListenableFuture<? extends RunScriptOnNode>> {
        private final Map<NodeMetadata, Exception> badNodes;
        private final Statement script;
        private final RunScriptOptions options;

        private TransformNodesIntoInitializedScriptRunners(Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
            this.badNodes = Preconditions.checkNotNull(badNodes, "badNodes");
            this.script = Preconditions.checkNotNull(script, "script");
            this.options = Preconditions.checkNotNull(options, "options");
        }

        @Override
        public ListenableFuture<RunScriptOnNode> apply(NodeMetadata node) {
            node = BaseComputeService.this.updateNodeWithCredentialsIfPresent(node, this.options);
            return BaseComputeService.this.userExecutor.submit(BaseComputeService.this.initScriptRunnerFactory.create(node, this.script, this.options, this.badNodes));
        }
    }
}

