/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.DigitalOcean2ComputeServiceAdapter;
import org.jclouds.digitalocean2.compute.extensions.DigitalOcean2ImageExtension;
import org.jclouds.digitalocean2.compute.functions.DropletStatusToStatus;
import org.jclouds.digitalocean2.compute.functions.DropletToNodeMetadata;
import org.jclouds.digitalocean2.compute.functions.ImageInRegionToImage;
import org.jclouds.digitalocean2.compute.functions.RegionToLocation;
import org.jclouds.digitalocean2.compute.functions.SizeToHardware;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.compute.options.DigitalOcean2TemplateOptions;
import org.jclouds.digitalocean2.compute.strategy.CreateKeyPairsThenCreateNodes;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.Size;
import org.jclouds.domain.Location;
import org.jclouds.util.Predicates2;

public class DigitalOcean2ComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Droplet, Size, ImageInRegion, Region> {
    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Droplet, Size, ImageInRegion, Region>>(){}).to(DigitalOcean2ComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Droplet, NodeMetadata>>(){}).to(DropletToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<ImageInRegion, Image>>(){}).to(ImageInRegionToImage.class);
        this.bind(new TypeLiteral<Function<Region, Location>>(){}).to(RegionToLocation.class);
        this.bind(new TypeLiteral<Function<Size, Hardware>>(){}).to(SizeToHardware.class);
        this.bind(new TypeLiteral<Function<Droplet.Status, NodeMetadata.Status>>(){}).to(DropletStatusToStatus.class);
        this.install(new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Droplet, Size, ImageInRegion, Region>(){});
        this.bind(CreateNodesInGroupThenAddToSet.class).to(CreateKeyPairsThenCreateNodes.class);
        this.bind(TemplateOptions.class).to(DigitalOcean2TemplateOptions.class);
        this.bind(NodeAndTemplateOptionsToStatement.class).to(NodeAndTemplateOptionsToStatementWithoutPublicKey.class);
        this.bind(new TypeLiteral<ImageExtension>(){}).to(DigitalOcean2ImageExtension.class);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<Integer> provideDropletRunningPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new DropletInStatusPredicate(api, Droplet.Status.ACTIVE), timeouts.nodeRunning, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected Predicate<Integer> provideDropletSuspendedPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new DropletInStatusPredicate(api, Droplet.Status.OFF), timeouts.nodeSuspended, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<Integer> provideDropletTerminatedPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new DropletTerminatedPredicate(api), timeouts.nodeTerminated, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.image-available")
    protected Predicate<Integer> provideImageAvailablePredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new ActionDonePredicate(api), timeouts.imageAvailable, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Singleton
    protected Predicate<Region> provideRegionAvailablePredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new RegionAvailablePredicate(), timeouts.imageAvailable, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    protected Predicate<Integer> provideActionCompletedPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry(new ActionDonePredicate(api), timeouts.imageAvailable, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @VisibleForTesting
    static class RegionAvailablePredicate
    implements Predicate<Region> {
        RegionAvailablePredicate() {
        }

        @Override
        public boolean apply(Region input) {
            return input.available();
        }
    }

    @VisibleForTesting
    static class DropletInStatusPredicate
    implements Predicate<Integer> {
        private final DigitalOcean2Api api;
        private final Droplet.Status status;

        public DropletInStatusPredicate(DigitalOcean2Api api, Droplet.Status status) {
            this.api = Preconditions.checkNotNull(api, "api must not be null");
            this.status = Preconditions.checkNotNull(status, "status must not be null");
        }

        @Override
        public boolean apply(Integer input) {
            Preconditions.checkNotNull(input, "droplet id");
            Droplet droplet = this.api.dropletApi().get(input);
            return droplet != null && this.status == droplet.status();
        }
    }

    @VisibleForTesting
    static class DropletTerminatedPredicate
    implements Predicate<Integer> {
        private final DigitalOcean2Api api;

        public DropletTerminatedPredicate(DigitalOcean2Api api) {
            this.api = Preconditions.checkNotNull(api, "api must not be null");
        }

        @Override
        public boolean apply(Integer input) {
            Preconditions.checkNotNull(input, "droplet id");
            Droplet droplet = this.api.dropletApi().get(input);
            return droplet == null;
        }
    }

    @VisibleForTesting
    static class ActionDonePredicate
    implements Predicate<Integer> {
        private final DigitalOcean2Api api;

        public ActionDonePredicate(DigitalOcean2Api api) {
            this.api = Preconditions.checkNotNull(api, "api must not be null");
        }

        @Override
        public boolean apply(Integer input) {
            Preconditions.checkNotNull(input, "action id cannot be null");
            Action current = this.api.actionApi().get(input);
            switch (current.status()) {
                case COMPLETED: {
                    return true;
                }
                case IN_PROGRESS: {
                    return false;
                }
            }
            throw new IllegalStateException("Resource is in invalid status: " + current.status().name());
        }
    }
}

