/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.ssh.SshKeys;

@Singleton
public class CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions {
    @VisibleForTesting
    public Function<RegionAndName, KeyPair> makeKeyPair;
    @VisibleForTesting
    public final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    @VisibleForTesting
    public final LoadingCache<RegionAndName, String> securityGroupMap;
    @VisibleForTesting
    public final Provider<RunInstancesOptions> optionsProvider;
    private final GroupNamingConvention.Factory namingConvention;

    @Inject
    public CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions(Function<RegionAndName, KeyPair> makeKeyPair, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap, Provider<RunInstancesOptions> optionsProvider, GroupNamingConvention.Factory namingConvention) {
        this.makeKeyPair = Preconditions.checkNotNull(makeKeyPair, "makeKeyPair");
        this.credentialsMap = Preconditions.checkNotNull(credentialsMap, "credentialsMap");
        this.securityGroupMap = Preconditions.checkNotNull(securityGroupMap, "securityGroupMap");
        this.optionsProvider = Preconditions.checkNotNull(optionsProvider, "optionsProvider");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
    }

    public RunInstancesOptions execute(String region, String group, Template template) {
        RunInstancesOptions instanceOptions = this.getOptionsProvider().get().asType(template.getHardware().getId());
        String keyPairName = this.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, template.getOptions());
        this.addSecurityGroups(region, group, template, instanceOptions);
        if (template.getOptions() instanceof EC2TemplateOptions) {
            String clientToken;
            Set<BlockDeviceMapping> blockDeviceMappings;
            byte[] userData;
            if (keyPairName != null) {
                instanceOptions.withKeyName(keyPairName);
            }
            if ((userData = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(template.getOptions())).getUserData()) != null) {
                instanceOptions.withUserData(userData);
            }
            if (!(blockDeviceMappings = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(template.getOptions())).getBlockDeviceMappings()).isEmpty()) {
                Preconditions.checkState("ebs".equals(template.getImage().getUserMetadata().get("rootDeviceType")), "BlockDeviceMapping only available on ebs boot");
                instanceOptions.withBlockDeviceMappings(blockDeviceMappings);
            }
            if ((clientToken = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(template.getOptions())).getClientToken()) != null) {
                instanceOptions.withClientToken(clientToken);
            }
        }
        return instanceOptions;
    }

    protected void addSecurityGroups(String region, String group, Template template, RunInstancesOptions instanceOptions) {
        Set<String> groups = this.getSecurityGroupsForTagAndOptions(region, group, null, template.getOptions());
        instanceOptions.withSecurityGroups(groups);
    }

    @VisibleForTesting
    public String createNewKeyPairUnlessUserSpecifiedOtherwise(String region, String group, TemplateOptions options) {
        String keyPairName = null;
        boolean shouldAutomaticallyCreateKeyPair = true;
        if (options instanceof EC2TemplateOptions && (keyPairName = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).getKeyPair()) == null) {
            shouldAutomaticallyCreateKeyPair = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).shouldAutomaticallyCreateKeyPair();
        }
        if (keyPairName == null && shouldAutomaticallyCreateKeyPair) {
            keyPairName = this.createOrImportKeyPair(region, group, options);
        } else if (keyPairName != null && options.getLoginPrivateKey() != null) {
            String pem = options.getLoginPrivateKey();
            KeyPair keyPair = KeyPair.builder().region(region).keyName(keyPairName).fingerprint(SshKeys.fingerprintPrivateKey(pem)).sha1OfPrivateKey(SshKeys.sha1PrivateKey(pem)).keyMaterial(pem).build();
            RegionAndName key = new RegionAndName(region, keyPairName);
            this.credentialsMap.put(key, keyPair);
        }
        if (options.getRunScript() != null) {
            RegionAndName regionAndName = new RegionAndName(region, keyPairName);
            Preconditions.checkArgument(this.credentialsMap.containsKey(regionAndName), "no private key configured for: %s; please use options.overrideLoginCredentialWith(rsa_private_text)", (Object)regionAndName);
        }
        return keyPairName;
    }

    protected String createOrImportKeyPair(String region, String group, TemplateOptions options) {
        RegionAndName regionAndGroup = new RegionAndName(region, group);
        KeyPair keyPair = this.makeKeyPair.apply(new RegionAndName(region, group));
        KeyPair origValue = this.credentialsMap.putIfAbsent(regionAndGroup, keyPair);
        if (origValue != null) {
            return origValue.getKeyName();
        }
        this.credentialsMap.put(new RegionAndName(region, keyPair.getKeyName()), keyPair);
        return keyPair.getKeyName();
    }

    @VisibleForTesting
    public Set<String> getSecurityGroupsForTagAndOptions(String region, @Nullable String group, @Nullable String vpcId, TemplateOptions options) {
        ImmutableSet.Builder groups = ImmutableSet.builder();
        if (group != null) {
            String markerGroup = this.namingConvention.create().sharedNameForGroup(group);
            if (this.userSpecifiedTheirOwnGroups(options)) {
                groups.addAll(((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).getGroups());
            } else {
                RegionNameAndIngressRules regionNameAndIngressRulesForMarkerGroup = new RegionNameAndIngressRules(region, markerGroup, options.getInboundPorts(), true, vpcId);
                groups.add(this.securityGroupMap.getUnchecked(regionNameAndIngressRulesForMarkerGroup));
            }
        }
        return groups.build();
    }

    protected boolean userSpecifiedTheirOwnGroups(TemplateOptions options) {
        return options instanceof EC2TemplateOptions && !((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).getGroups().isEmpty();
    }

    @VisibleForTesting
    public Provider<RunInstancesOptions> getOptionsProvider() {
        return this.optionsProvider;
    }
}

