/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain.lbaas.v1;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.LBaaSStatus;

public class Member {
    @Named(value="tenant_id")
    private String tenantId;
    private String address;
    @Named(value="protocol_port")
    private Integer protocolPort;
    @Named(value="pool_id")
    private String poolId;
    private Integer weight;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    private String id;
    private LBaaSStatus status;
    @Named(value="status_description")
    private String statusDescription;

    @ConstructorProperties(value={"id", "tenant_id", "pool_id", "address", "protocol_port", "weight", "admin_state_up", "status", "status_description"})
    private Member(String id, String tenantId, String poolId, String address, Integer protocolPort, Integer weight, Boolean adminStateUp, LBaaSStatus status, String statusDescription) {
        this.id = id;
        this.tenantId = tenantId;
        this.poolId = poolId;
        this.address = address;
        this.protocolPort = protocolPort;
        this.weight = weight;
        this.adminStateUp = adminStateUp;
        this.status = status;
        this.statusDescription = statusDescription;
    }

    private Member() {
    }

    private Member(Member member) {
        this(member.id, member.tenantId, member.poolId, member.address, member.protocolPort, member.weight, member.adminStateUp, member.status, member.statusDescription);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getPoolId() {
        return this.poolId;
    }

    @Nullable
    public String getAddress() {
        return this.address;
    }

    @Nullable
    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    @Nullable
    public Integer getWeight() {
        return this.weight;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public LBaaSStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getStatusDescription() {
        return this.statusDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member that = (Member)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.poolId, that.poolId) && Objects.equal(this.address, that.address) && Objects.equal(this.protocolPort, that.protocolPort) && Objects.equal(this.weight, that.weight) && Objects.equal(this.adminStateUp, that.adminStateUp) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.statusDescription, that.statusDescription);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.tenantId, this.poolId, this.address, this.protocolPort, this.weight, this.adminStateUp, this.status, this.statusDescription});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("poolId", this.poolId).add("address", this.address).add("protocolPort", this.protocolPort).add("weight", this.weight).add("adminStateUp", this.adminStateUp).add("status", (Object)this.status).add("statusDescription", this.statusDescription).toString();
    }

    public static CreateBuilder createBuilder(String poolId, String address, Integer port) {
        return new CreateBuilder(poolId, address, port);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class UpdateMember
    extends Member {
        private UpdateMember(Member member) {
            super(member);
        }
    }

    public static class CreateMember
    extends Member {
        private CreateMember(Member member) {
            super(member);
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateMember build() {
            return new UpdateMember(this.member);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String poolId, String address, Integer port) {
            ((CreateBuilder)this.poolId(poolId)).address(address).protocolPort(port);
        }

        public CreateBuilder tenantId(String tenantId) {
            this.member.tenantId = tenantId;
            return this.self();
        }

        public CreateBuilder address(String address) {
            this.member.address = address;
            return this.self();
        }

        public CreateBuilder protocolPort(Integer protocolPort) {
            this.member.protocolPort = protocolPort;
            return this.self();
        }

        public CreateMember build() {
            return new CreateMember(this.member);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected Member member = new Member();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType poolId(String poolId) {
            this.member.poolId = poolId;
            return this.self();
        }

        public ParameterizedBuilderType weight(Integer weight) {
            this.member.weight = weight;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.member.adminStateUp = adminStateUp;
            return this.self();
        }
    }
}

