/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import javax.inject.Inject;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;

public class FindSecurityGroupOrCreate
extends CacheLoader<RegionAndName, SecurityGroup> {
    protected final Function<RegionSecurityGroupNameAndPorts, SecurityGroup> groupCreator;

    @Inject
    public FindSecurityGroupOrCreate(Function<RegionSecurityGroupNameAndPorts, SecurityGroup> groupCreator) {
        this.groupCreator = Preconditions.checkNotNull(groupCreator, "groupCreator");
    }

    @Override
    public SecurityGroup load(RegionAndName in) {
        return this.createNewSecurityGroup(in);
    }

    private SecurityGroup createNewSecurityGroup(RegionAndName in) {
        Preconditions.checkState(Preconditions.checkNotNull(in, "regionSecurityGroupNameAndPorts") instanceof RegionSecurityGroupNameAndPorts, "programming error: when issuing get to this cacheloader, you need to pass an instance of RegionSecurityGroupNameAndPorts, not %s", (Object)in);
        RegionSecurityGroupNameAndPorts regionSecurityGroupNameAndPorts = (RegionSecurityGroupNameAndPorts)RegionSecurityGroupNameAndPorts.class.cast(in);
        return this.groupCreator.apply(regionSecurityGroupNameAndPorts);
    }

    public String toString() {
        return "returnExistingSecurityGroupInRegionOrCreateAsNeeded()";
    }
}

