/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindMapToIndexedFormParams
implements Binder {
    private final String keyPattern;
    private final String valuePattern;

    protected BindMapToIndexedFormParams(String keyPattern, String valuePattern) {
        this.keyPattern = keyPattern;
        this.valuePattern = valuePattern;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (Preconditions.checkNotNull(input, "input") instanceof Iterable) {
            input = Maps.uniqueIndex((Iterable)((Object)input), new Function<String, String>(){
                int index = 1;

                @Override
                public String apply(String input) {
                    return this.index++ + "";
                }
            });
        }
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "this binder is only valid for Map");
        Map mapping = input;
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        int amazonOneBasedIndex = 1;
        for (Map.Entry entry : mapping.entrySet()) {
            builder.put(String.format(this.keyPattern, amazonOneBasedIndex), (String)entry.getKey());
            builder.put(String.format(this.valuePattern, amazonOneBasedIndex), (String)entry.getValue());
            ++amazonOneBasedIndex;
        }
        SetMultimap<String, String> forms = Multimaps.forMap(builder.build());
        return (R)(forms.isEmpty() ? request : ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(forms)).build());
    }
}

