/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class RouteOptions
extends BaseEC2RequestOptions {
    public RouteOptions dryRun() {
        this.formParameters.put("DryRun", "true");
        return this;
    }

    public boolean isDryRun() {
        return this.getFirstFormOrNull("DryRun") != null;
    }

    public RouteOptions destinationCidrBlock(String destinationCidrBlock) {
        this.formParameters.put("DestinationCidrBlock", Preconditions.checkNotNull(destinationCidrBlock, "destinationCidrBlock"));
        return this;
    }

    public String getDestinationCidrBlock() {
        return this.getFirstFormOrNull("DestinationCidrBlock");
    }

    public RouteOptions destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
        this.formParameters.put("DestinationIpv6CidrBlock", Preconditions.checkNotNull(destinationIpv6CidrBlock, "destinationIpv6CidrBlock"));
        return this;
    }

    public String getDestinationIpv6CidrBlock() {
        return this.getFirstFormOrNull("DestinationIpv6CidrBlock");
    }

    public RouteOptions gatewayId(String gatewayId) {
        this.formParameters.put("GatewayId", Preconditions.checkNotNull(gatewayId, "gatewayId"));
        return this;
    }

    public String getGatewayId() {
        return this.getFirstFormOrNull("GatewayId");
    }

    public RouteOptions egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
        this.formParameters.put("EgressOnlyInternetGatewayId", Preconditions.checkNotNull(egressOnlyInternetGatewayId, "egressOnlyInternetGatewayId"));
        return this;
    }

    public String getEgressOnlyInternetGatewayId() {
        return this.getFirstFormOrNull("EgressOnlyInternetGatewayId");
    }

    public RouteOptions natGatewayId(String natGatewayId) {
        this.formParameters.put("NatGatewayId", Preconditions.checkNotNull(natGatewayId, "natGatewayId"));
        return this;
    }

    public String getNatGatewayId() {
        return this.getFirstFormOrNull("NatGatewayId");
    }

    public RouteOptions networkInterfaceId(String networkInterfaceId) {
        this.formParameters.put("NetworkInterfaceId", Preconditions.checkNotNull(networkInterfaceId, "networkInterfaceId"));
        return this;
    }

    public String getNetworkInterfaceId() {
        return this.getFirstFormOrNull("NetworkInterfaceId");
    }

    public RouteOptions instanceId(String instanceId) {
        this.formParameters.put("InstanceId", Preconditions.checkNotNull(instanceId, "instanceId"));
        return this;
    }

    public String getInstanceId() {
        return this.getFirstFormOrNull("InstanceId");
    }

    public RouteOptions vpcPeeringConnectionId(String vpcPeeringConnectionId) {
        this.formParameters.put("VpcPeeringConnectionId", Preconditions.checkNotNull(vpcPeeringConnectionId, "vpcPeeringConnectionId"));
        return this;
    }

    public String getVpcPeeringConnectionId() {
        return this.getFirstFormOrNull("VpcPeeringConnectionId");
    }

    public static class Builder {
        public static RouteOptions dryRun() {
            RouteOptions options = new RouteOptions();
            return options.dryRun();
        }

        public static RouteOptions destinationCidrBlock(String destinationCidrBlock) {
            RouteOptions options = new RouteOptions();
            return options.destinationCidrBlock(destinationCidrBlock);
        }

        public static RouteOptions destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            RouteOptions options = new RouteOptions();
            return options.destinationIpv6CidrBlock(destinationIpv6CidrBlock);
        }

        public static RouteOptions gatewayId(String gatewayId) {
            RouteOptions options = new RouteOptions();
            return options.gatewayId(gatewayId);
        }

        public static RouteOptions egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            RouteOptions options = new RouteOptions();
            return options.egressOnlyInternetGatewayId(egressOnlyInternetGatewayId);
        }

        public static RouteOptions natGatewayId(String natGatewayId) {
            RouteOptions options = new RouteOptions();
            return options.natGatewayId(natGatewayId);
        }

        public static RouteOptions networkInterfaceId(String networkInterfaceId) {
            RouteOptions options = new RouteOptions();
            return options.networkInterfaceId(networkInterfaceId);
        }

        public static RouteOptions vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            RouteOptions options = new RouteOptions();
            return options.vpcPeeringConnectionId(vpcPeeringConnectionId);
        }

        public static RouteOptions instanceId(String instanceId) {
            RouteOptions options = new RouteOptions();
            return options.instanceId(instanceId);
        }
    }
}

