/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class NodeMetadataImpl
extends ComputeMetadataImpl
implements NodeMetadata {
    private final NodeMetadata.Status status;
    private final String backendStatus;
    private final int loginPort;
    private final Set<String> publicAddresses;
    private final Set<String> privateAddresses;
    @Nullable
    private final LoginCredentials credentials;
    @Nullable
    private final String group;
    @Nullable
    private final String imageId;
    @Nullable
    private final Hardware hardware;
    @Nullable
    private final OperatingSystem os;
    @Nullable
    private final String hostname;

    public NodeMetadataImpl(String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, @Nullable String group, @Nullable Hardware hardware, @Nullable String imageId, @Nullable OperatingSystem os, NodeMetadata.Status status, @Nullable String backendStatus, int loginPort, Iterable<String> publicAddresses, Iterable<String> privateAddresses, @Nullable LoginCredentials credentials, String hostname) {
        super(ComputeType.NODE, providerId, name, id, location, uri, userMetadata, tags);
        this.group = group;
        this.hardware = hardware;
        this.imageId = imageId;
        this.os = os;
        this.status = Preconditions.checkNotNull(status, "status");
        this.backendStatus = backendStatus;
        this.loginPort = loginPort;
        this.publicAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(publicAddresses, "publicAddresses"));
        this.privateAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(privateAddresses, "privateAddresses"));
        this.credentials = credentials;
        this.hostname = hostname;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public Hardware getHardware() {
        return this.hardware;
    }

    @Override
    public LoginCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public Set<String> getPublicAddresses() {
        return this.publicAddresses;
    }

    @Override
    public Set<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    @Override
    public NodeMetadata.Status getStatus() {
        return this.status;
    }

    @Override
    public String getBackendStatus() {
        return this.backendStatus;
    }

    @Override
    public int getLoginPort() {
        return this.loginPort;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.os;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper helper = this.computeToStringPrefix();
        helper.add("group", this.getGroup()).add("imageId", this.getImageId()).add("os", this.getOperatingSystem()).add("status", ComputeServiceUtils.formatStatus(this)).add("loginPort", this.getLoginPort()).add("hostname", this.getHostname());
        if (!this.getPrivateAddresses().isEmpty()) {
            helper.add("privateAddresses", this.getPrivateAddresses());
        }
        if (!this.getPublicAddresses().isEmpty()) {
            helper.add("publicAddresses", this.getPublicAddresses());
        }
        helper.add("hardware", this.getHardware()).add("loginUser", this.credentials != null ? this.credentials.identity : null);
        return this.addComputeToStringSuffix(helper);
    }
}

